<div class="card sidebar-profile-card">
	<div class="card-body p-4 text-center">
		<?php $this->insert('components/avatar', [
			'avatar' => auth()->user()->avatar(),
			'username' => auth()->user()->displayName(),
			'class' => 'avatar avatar-xl mb-3 rounded',
		]); ?>
		<h3 class="m-0 mb-2 username__<?php echo auth()->user()->primaryRoleSlug() ?>">
			<?php echo auth()->user()->displayName(); ?>
		</h3>
		<div>
			<?php foreach (auth()->user()->roles() as $role): ?>
				<span class="role__default role__<?php echo $role["slug"]; ?>">
					<?php echo $role["name"] ?>
				</span>
			<?php endforeach; ?>
		</div>
	</div>
	<div>
		<?php $items = [
			[
				'url' => url('account.profile.index'),
				'icon' => 'ti ti-user',
				'text' => t__('Profile'),
				'module' => null,
			],
			[
				'url' => "https://checkout.tebex.io/payment-history",
				'icon' => 'ti ti-shopping-cart',
				'text' => t__('Orders'),
				'module' => 'tebex_store',
			],
			[
				'url' => url('account.orders'),
				'icon' => 'ti ti-shopping-cart',
				'text' => t__('Orders'),
				'module' => 'store',
			],
			[
				'url' => url('account.subscriptions'),
				'icon' => 'ti ti-refresh',
				'text' => t__('Subscriptions'),
				'module' => 'store',
			],
			[
				'url' => url('account.credit-history'),
				'icon' => 'ti ti-coins',
				'text' => t__('Credit History'),
				'module' => 'credit',
			],
			[
				'url' => url('account.applications'),
				'icon' => 'ti ti-file-description',
				'text' => t__('Applications'),
				'module' => 'application',
			]
		]; ?>
		<h3 class="d-block h5 mb-0 px-4 py-3 text-uppercase bg-body">
			<?php e__('My Account') ?>
		</h3>
		<div class="d-flex flex-column py-2">
			<?php foreach ($items as $item): ?>
				<?php if ($item["module"] !== null && !modules($item["module"])->isActive()) continue; ?>
				<a href="<?php echo $item["url"]; ?>" class="sidebar-link <?php _active($item["url"] == request()->getUrl()->getOriginalUrl()); ?>">
					<i class="<?php echo $item["icon"] ?> opacity-60 me-2"></i>
					<?php echo $item["text"] ?>
				</a>
			<?php endforeach; ?>
		</div>
		<h3 class="d-block h5 mb-0 px-4 py-3 text-uppercase bg-body">
			<?php e__('Settings') ?>
		</h3>
		<div class="d-flex flex-column py-2">
			<a href="<?php echo url('account.settings.profile') ?>" class="sidebar-link <?php _active($route_type == "account-profile-settings"); ?>">
				<i class="ti ti-settings opacity-60 me-2"></i>
				<?php e__('Edit Profile') ?>
			</a>
			<a href="<?php echo url('account.settings.security') ?>" class="sidebar-link <?php _active($route_type == "account-security-settings"); ?>">
				<i class="ti ti-shield-lock opacity-60 me-2"></i>
				<?php e__('Security') ?>
			</a>
			<?php if (modules('account_linking')->isActive()): ?>
				<a href="<?php echo url('account.settings.linked-accounts') ?>" class="sidebar-link <?php _active($route_type == "account-linked-accounts"); ?>">
					<i class="ti ti-link opacity-60 me-2"></i>
					<?php e__('Linked Accounts') ?>
				</a>
			<?php endif; ?>
			<?php if ($show_discord_sync_btn): ?>
				<?php if (auth()->user()->data('discordUserID')): ?>
					<form data-toggle="form-submit-with-loader" action="<?php echo url('discord.unlink') ?>" method="post">
						<?php _csrf(); ?>
						<button type="submit" class="btn btn-link w-full justify-content-start sidebar-link" onclick="return confirm('<?php e__('Are you sure want to unlink your discord account?') ?>');">
							<i class="ti ti-brand-discord opacity-60 me-2"></i>
							<?php e__('Unlink Discord Account') ?>
						</button>
					</form>
				<?php else: ?>
					<a href="<?php echo url('discord.link') ?>" class="sidebar-link">
						<i class="ti ti-brand-discord opacity-60 me-2"></i>
						<?php e__('Link Discord Account') ?>
					</a>
				<?php endif; ?>
			<?php endif; ?>
		</div>
	</div>
</div>