<style>
	.tebex-auth-card {
		overflow: hidden;
		height: 90px;
	}
	.tebex-auth-card img {
		overflow: hidden;
		height: 150px;
		margin-left: 1rem;
		margin-right: -0.5rem;
		margin-top: 0.5rem;
	}
	.tebex-cart-count {
		position: absolute;
		top: -10px;
		right: -10px;
		background-color: red;
		color: #fff;
		border-radius: 50%;
		width: 20px;
		height: 20px;
		font-size: 12px;
		display: flex;
		justify-content: center;
		align-items: center;
	}
</style>
<div x-show="basketIdent === null && username === null" class="tebex-auth-card card mb-3">
	<div class="d-flex justify-content-between align-items-center">
		<div class="d-flex gap-2">
			<?php if ($game_type == "minecraft"): ?>
				<img src="https://mc-heads.net/body/mhf_steve/right" alt="Steve">
			<?php endif; ?>
			<div class="mt-4 ms-3">
				<div class="card-title mb-0"><?php e__('Guest'); ?></div>
				<a href="<?php echo url('store.login') ?>" class="text-muted small"><?php e__('Click to Login'); ?></a>
			</div>
		</div>
	</div>
</div>
<div x-show="basketIdent !== null && username !== null" class="tebex-auth-card card mb-3">
	<div class="d-flex justify-content-between">
		<div class="d-flex gap-2">
			<?php if ($game_type == 'minecraft'): ?>
				<img x-bind:src="`https://mc-heads.net/body/${username}/right`" alt="Steve">
			<?php endif; ?>
			<div class="mt-4 ms-3">
				<div class="card-title mb-0" x-text="username"></div>
				<div class="text-muted small cursor-pointer" @click="logout()"><?php e__('Logout'); ?></div>
			</div>
		</div>
		<div class="mt-4 me-3">
			<a href="<?php echo url('cart.index') ?>" class="btn btn-primary btn-icon position-relative">
				<span class="tebex-cart-count" x-text="cartCount"></span>
				<i class="ti ti-shopping-cart"></i>
			</a>
		</div>
	</div>
</div>