<!DOCTYPE html>
<html lang="<?php echo $this->e($lang) ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="author" content="LeaderOS">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico?cache=<?php echo settings("updatedAt") ?>">
	
	<title><?php echo seo()->title(); ?></title>
	<meta name="description" content="<?php echo seo()->description(); ?>" />
	<link rel="canonical" href="<?php echo website_url(); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?php echo seo()->title(); ?>" />
	<meta property="og:description" content="<?php echo seo()->description(); ?>" />
	<meta property="og:url" content="<?php echo website_url(); ?>" />
	<meta property="og:site_name" content="<?php echo settings("serverName"); ?>" />
	<?php if (seo()->image() != null): ?>
		<meta property="og:image" content="<?php echo seo()->image(); ?>" />
	<?php endif; ?>
	
	<!-- CSRF -->
	<meta name="csrf-token" content="<?php echo csrf_token(); ?>">
	
	<!-- EXTRAS -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.4.0/dist/select2-bootstrap4.min.css">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css" />
	
	<!-- FONTS -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="https://site-assets.fontawesome.com/releases/v6.4.2/css/all.css">
	
	<!-- THEMES -->
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/tabler.min.css'); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/extra.css'); ?>">
	
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/plugins/ckeditor/content-styles.css'); ?>">
	
	<style>
		:host, :root, [data-bs-theme=light] {
			--tblr-primary: <?php echo theme()->settings('color'); ?>;
		}
	</style>
	
	<?php echo $this->section('styles'); ?>
	<?php echo $this->section('head'); ?>
	
	<!-- CUSTOM CSS -->
	<style type="text/css">
		<?php echo settings('customCSS'); ?>
	</style>
</head>
<body data-bs-theme="<?php echo $this->e($theme_mode) ?>" class="d-flex flex-column">
<div class="page page-center auth-layout">
	<div class="container container-tight py-4">
		<div class="text-center mb-4">
			<a href="<?php echo url('home') ?>">
				<img src="<?php echo theme()->settings('headerLogo') ?>" alt="<?php echo settings('serverName') ?>" class="auth-logo">
			</a>
		</div>
		
		<?php echo $this->section('content') ?>
	</div>
	
	<div class="text-center mb-4">
		<?php powered_by_leaderos(); ?>
	</div>
</div>

<script>
	var defaultMode = "<?php echo theme()->settings('defaultMode'); ?>";
</script>

<script>
	var lang = {
		loading: "<?php e__('Loading...'); ?>",
	}
</script>

<?php if (modules('cookie_consent')->isActive()) : ?>
	<script type="text/javascript" src="https://www.termsfeed.com/public/cookie-consent/4.0.0/cookie-consent.js" charset="UTF-8"></script>
	<script type="text/javascript" charset="UTF-8">
		document.addEventListener('DOMContentLoaded', function () {
			cookieconsent.run({"notice_banner_type":"simple","consent_type":"express","palette":"dark","language":"<?php echo $lang; ?>","page_load_consent_levels":["strictly-necessary", "functionality", "tracking", "targeting"],"notice_banner_reject_button_hide":true,"preferences_center_close_button_hide":false,"page_refresh_confirmation_buttons":false,"website_name":"<?php echo settings('serverName') ?>","website_privacy_policy_url":"<?php echo website_url('/privacy') ?>"});
		});
	</script>
<?php endif; ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/vanilla-lazyload/16.1.0/lazyload.min.js"></script>

<script src="<?php echo $this->asset('/js/main.min.js'); ?>"></script>
<script src="<?php echo $this->asset('/js/tabler.min.js'); ?>"></script>

<?php echo $this->section('scripts')?>

<script>
	$(".toggle-password").on("click", function() {
		var button = $(this);
		var input = $($(this).attr("data-target"));
		if (input.attr("type") == "password") {
			input.attr("type", "text");
			$(this).find("i").removeClass("ti-eye").addClass("ti-eye-off");
		} else {
			input.attr("type", "password");
			$(this).find("i").removeClass("ti-eye-off").addClass("ti-eye");
		}
	});
</script>
</body>
</html>