<!DOCTYPE html>
<html lang="<?php echo $this->e($lang) ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="author" content="LeaderOS">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico?cache=<?php echo settings("updatedAt") ?>">
	
	<title><?php echo seo()->title(); ?></title>
	<meta name="description" content="<?php echo seo()->description(); ?>" />
	<link rel="canonical" href="<?php echo website_url(); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?php echo seo()->title(); ?>" />
	<meta property="og:description" content="<?php echo seo()->description(); ?>" />
	<meta property="og:url" content="<?php echo website_url(); ?>" />
	<meta property="og:site_name" content="<?php echo settings("serverName"); ?>" />
	<?php if (seo()->image() != null): ?>
		<meta property="og:image" content="<?php echo seo()->image(); ?>" />
	<?php endif; ?>
	
	<!-- EXTRAS -->
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css" />
	
	<!-- FONTS -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="https://site-assets.fontawesome.com/releases/v6.4.2/css/all.css">
	
	<!-- THEMES -->
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/tabler.min.css'); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/extra.css'); ?>">
	
	<style>
		:host, :root, [data-bs-theme=light] {
			--tblr-primary: <?php echo theme()->settings('color'); ?>;
		}
	</style>
	
	<?php echo $this->section('styles'); ?>
	<?php echo $this->section('head'); ?>
	
	<!-- CUSTOM CSS -->
	<style type="text/css">
		<?php echo settings('customCSS'); ?>
	</style>
</head>
<body data-bs-theme="<?php echo $this->e($theme_mode) ?>" class=" border-top-wide border-primary d-flex flex-column">

<div class="page page-center">
	<div class="container-tight py-4">
		<div class="empty">
			<?php echo $this->section('content') ?>
		</div>
	</div>
</div>

<script>
	var defaultMode = "<?php echo theme()->settings('defaultMode'); ?>";
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/vanilla-lazyload/16.1.0/lazyload.min.js"></script>

<script src="<?php echo $this->asset('/js/main.min.js'); ?>"></script>
<script src="<?php echo $this->asset('/js/tabler.min.js'); ?>"></script>

<?php echo $this->section('scripts')?>
</body>
</html>