<!DOCTYPE html>
<html lang="<?php echo $this->e($lang) ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="author" content="LeaderOS">
	<link rel="shortcut icon" type="image/x-icon" href="/favicon.ico?cache=<?php echo settings("updatedAt") ?>">
	
	<title><?php echo seo()->title(); ?></title>
	<meta name="description" content="<?php echo seo()->description(); ?>" />
	<link rel="canonical" href="<?php echo website_url(); ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="<?php echo seo()->title(); ?>" />
	<meta property="og:description" content="<?php echo seo()->description(); ?>" />
	<meta property="og:url" content="<?php echo website_url(); ?>" />
	<meta property="og:site_name" content="<?php echo settings("serverName"); ?>" />
	<?php if (seo()->image() != null): ?>
		<meta property="og:image" content="<?php echo seo()->image(); ?>" />
	<?php endif; ?>
	
	<!-- CSRF -->
	<meta name="csrf-token" content="<?php echo csrf_token(); ?>">
	
	<!-- EXTRAS -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/8.11.8/sweetalert2.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.4.0/dist/select2-bootstrap4.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.3/tiny-slider.min.css">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css" />
	
	<!-- FONTS -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
	<link rel="stylesheet" type="text/css" href="https://site-assets.fontawesome.com/releases/v6.4.2/css/all.css">
	
	<!-- THEMES -->
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/tabler.min.css'); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/extra.css'); ?>">
	
	<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/plugins/ckeditor/content-styles.css'); ?>">
	
	<style>
		:host, :root, [data-bs-theme=light] {
			--tblr-primary: <?php echo theme()->settings('color'); ?>;
		}
	</style>
	
	<?php echo $this->section('styles'); ?>
	<?php echo $this->section('head'); ?>
	
	<!-- CUSTOM CSS -->
	<style type="text/css">
		<?php echo settings('customCSS'); ?>
	</style>
	
	<!-- ROLE CSS -->
	<style type="text/css">
		<?php foreach ($roles as $role): ?>
			<?php if ($role["usernameCSS"]): ?>
				.username__<?php echo $role["slug"]; ?> { <?php echo $role["usernameCSS"]; ?> }
			<?php endif; ?>
			
			<?php if ($role["badgeCSS"]): ?>
				.role__<?php echo $role["slug"]; ?> { <?php echo $role["badgeCSS"]; ?> }
			<?php endif; ?>
		<?php endforeach; ?>
	</style>
	
	<?php if (modules("tebex_store")->isActive()): ?>
		<style>
			.shopping-cart-count { display: none; }
		</style>
	<?php endif; ?>
</head>
<body data-bs-theme="<?php echo $this->e($theme_mode); ?>">
<div class="page">
	<?php $this->insert('partials/header') ?>
	
	<div class="page-wrapper">
		<?php echo $this->section('content') ?>
		
		<?php $this->insert('partials/footer') ?>
	</div>
</div>

<script>
	var $onlineAPI = "<?php echo settings('onlineAPI'); ?>";
	var defaultMode = "<?php echo theme()->settings('defaultMode'); ?>";
</script>

<script>
	var lang = {
		credits: "<?php e__('%credit% credit(s)'); ?>",
		search: "<?php e__('Search...'); ?>",
		loading: "<?php e__('Loading...'); ?>",
		confirm_delete: "<?php e__('Are you sure you want to delete?'); ?>",
		player_not_found: "<?php e__('Player not found!'); ?>",
		play_again: "<?php e__('Play again'); ?>",
		spinning: "<?php e__('Spinning...'); ?>",
		apply: "<?php e__('Apply'); ?>",
		remove: "<?php e__('Remove'); ?>",
		alert_btn_ok: "<?php e__('OK'); ?>",
		alert_btn_cancel: "<?php e__('Cancel'); ?>",
		alert_btn_confirm: "<?php e__('Confirm'); ?>",
		alert_btn_buy_credit: "<?php e__('Buy Credits'); ?>",
		alert_title_success: "<?php e__('Success!'); ?>",
		alert_title_error: "<?php e__('Error!'); ?>",
		alert_title_warning: "<?php e__('Warning!'); ?>",
		alert_title_you_lost: "<?php e__('You Lost!'); ?>",
		alert_title_you_win: "<?php e__('You Win!'); ?>",
		alert_message_server_address_copied: "<?php e__('Server address copied to clipboard!'); ?>",
		alert_message_something_went_wrong: "<?php e__('Something went wrong! Please try again later.'); ?>",
		alert_message_lottery_error_duration: "<?php e__('You have to wait until %date% to re-spin for free.'); ?>",
		alert_message_lottery_you_lost: "<?php e__('Sorry, you lost! Try again next time.'); ?>",
		alert_message_lottery_you_win: "<?php e__('Congratulations! You won <strong>%prize%</strong>!'); ?>",
		alert_message_lottery_you_win_chest: "<?php e__('The product has been added to your chest.'); ?>",
		alert_message_lottery_you_win_credit: "<?php e__('Current Credit: %credit%'); ?>",
		alert_message_lottery_credit_error: "<?php e__("You don't have enough credit to play the game."); ?>",
		alert_message_chest_confirm: "<?php e__('Please make sure you are on the server before confirming, otherwise the product may not reach you!'); ?>",
		alert_message_chest_sending: "<?php e__('Delivery is in progress, please wait and do not leave the page...'); ?>",
		alert_message_chest_sent: "<?php e__('The product has been successfully delivered! Have fun!'); ?>",
		alert_message_chest_server_error: "<?php e__('There was a problem connecting to the server! Please try again later.'); ?>",
		alert_message_chest_amount_error: "<?php e__('You can receive a maximum of %amount%!'); ?>",
		alert_message_login: "<?php e__('Please login to do this.'); ?>",
		help_voting_success: "<?php e__('You have successfully voted!'); ?>",
		alert_message_checkout_credit_error: "<?php e__("You don't have enough credit."); ?>",
		alert_message_checkout_success: "<?php e__('Your purchase has been completed and added to your chest.'); ?>",
		alert_message_checkout_quantity_error: "<?php e__('Enter a valid quantity!'); ?>",
		alert_message_checkout_stock_error: "<?php e__('Stock limit has been reached for this product!'); ?>",
		alert_message_checkout_stock_error2: "<?php e__('Not enough items in the stock!'); ?>",
		alert_message_checkout_cart_empty_error: "<?php e__('Your shopping cart is empty!'); ?>",
		alert_message_checkout_coupon_invalid: "<?php e__('Coupon is invalid!') ?>",
		alert_message_checkout_coupon_invalid_for_cart: "<?php e__('This coupon is not valid for your shopping cart!') ?>",
		alert_message_checkout_coupon_used: "<?php e__('You have used this coupon before!') ?>",
		alert_message_checkout_coupon_expired: "<?php e__('This coupon has expired!') ?>",
		alert_message_checkout_coupon_login: "<?php e__('You must be logged in to use coupons!') ?>",
		alert_message_checkout_coupon_success: "<?php e__('Coupon applied successfully!') ?>",
		alert_message_checkout_coupon_price: "<?php e__('You must have a minimum of %amount% credits in your account to use this coupon!') ?>",
		alert_message_not_found: "<?php e__('Not found!'); ?>",
		limited_stock: "<?php e__('Limited Stock!') ?>",
		out_of_stock: "<?php e__('Out of Stock!') ?>"
	}
</script>

<?php if (modules('cookie_consent')->isActive()) : ?>
	<script type="text/javascript" src="https://www.termsfeed.com/public/cookie-consent/4.0.0/cookie-consent.js" charset="UTF-8"></script>
	<script type="text/javascript" charset="UTF-8">
		document.addEventListener('DOMContentLoaded', function () {
			cookieconsent.run({"notice_banner_type":"simple","consent_type":"express","palette":"dark","language":"<?php echo $lang; ?>","page_load_consent_levels":["strictly-necessary", "functionality", "tracking", "targeting"],"notice_banner_reject_button_hide":true,"preferences_center_close_button_hide":false,"page_refresh_confirmation_buttons":false,"website_name":"<?php echo settings('serverName') ?>","website_privacy_policy_url":"<?php echo website_url('/privacy') ?>"});
		});
	</script>
<?php endif; ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.6/clipboard.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/i18n/tr.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/8.11.8/sweetalert2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/vanilla-lazyload/16.1.0/lazyload.min.js"></script>
<?php if (modules('announcements')->isActive()) : ?>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.Marquee/1.5.0/jquery.marquee.min.js"></script>
<?php endif; ?>

<script src="<?php echo $this->asset('/js/main.min.js'); ?>"></script>
<script src="<?php echo $this->asset('/js/tabler.min.js'); ?>"></script>

<?php if (modules('google_analytics')->isActive()) : ?>
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script cookie-consent="targeting" async src="https://www.googletagmanager.com/gtag/js?id=<?php echo modules('google_analytics')->settings('ua'); ?>"></script>
	<script cookie-consent="targeting">
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag("js", new Date());
		
		gtag("config", "<?php echo modules('google_analytics')->settings('ua'); ?>");
	</script>
<?php endif; ?>

<?php if (modules('tawkto')->isActive()) : ?>
	<!--Start of Tawk.to Script-->
	<script cookie-consent="functionality" type="text/javascript">
		var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
		(function(){
			var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
			s1.async=true;
			s1.src='https://embed.tawk.to/<?php echo modules('tawkto')->settings('id'); ?>/<?php echo modules('tawkto')->settings('widgetID'); ?>';
			s1.charset='UTF-8';
			s1.setAttribute('crossorigin','*');
			s0.parentNode.insertBefore(s1,s0);
		})();
	</script>
	<!--End of Tawk.to Script-->
<?php endif; ?>

<?php if (modules('popup')->isActive()): ?>
	<div class="modal fade" id="popupModal" tabindex="-1" aria-labelledby="popupModalLabel" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header" style="border-bottom: none !important;">
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body p-0">
					<a href="<?php echo modules('popup')->settings('link'); ?>">
						<img class="w-100" src="/assets/core/images/uploads/<?php echo modules('popup')->settings('image'); ?>">
					</a>
				</div>
			</div>
		</div>
	</div>
	
	<script>
		$(document).ready(function() {
			// check popup localstorage last close time (shows every 30 mins)
			if (localStorage.getItem('popupLastClose') === null || (new Date().getTime() - localStorage.getItem('popupLastClose')) > 1800000) {
				// show popup and set last close time
				$('#popupModal').modal('show');
				document.getElementById('popupModal').addEventListener('hidden.bs.modal', event => {
					localStorage.setItem('popupLastClose', new Date().getTime());
				})
			}
		});
	</script>
<?php endif; ?>

<?php echo $this->section('scripts')?>

</body>
</html>