<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"text" => t__('Applications')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Applications') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($applications) > 0): ?>
							<table class="table table-hover">
								<thead>
								<tr>
									<th class="text-center" style="width: 40px;">ID</th>
									<th><?php e__('Title') ?></th>
									<th><?php e__('Reason') ?></th>
									<th class="text-center"><?php e__('Status') ?></th>
									<th class="text-end"> </th>
								</tr>
								</thead>
								<tbody>
								<?php foreach ($applications as $application): ?>
									<tr>
										<td class="text-center" style="width: 40px;">
											#<?php echo $application["id"]; ?>
										</td>
										<td>
											<?php echo $application["title"]; ?>
										</td>
										<td>
											<?php echo ($application["reason"] == '') ? '-' : $application["reason"]; ?>
										</td>
										<td class="text-center">
											<?php if ($application["status"] == 0): ?>
												<span class="badge text-white bg-danger"><?php e__('Rejected') ?></span>
											<?php elseif ($application["status"] == 1): ?>
												<span class="badge text-white bg-success"><?php e__('Approved') ?></span>
											<?php elseif ($application["status"] == 2): ?>
												<span class="badge text-white bg-warning"><?php e__('Pending Approval') ?></span>
											<?php else: ?>
												<span class="badge text-white bg-danger"><?php e__('Error') ?></span>
											<?php endif; ?>
										</td>
										<td class="text-end">
											<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('applications.show', ['id' => $application["id"]]); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('View') ?>">
												<i class="ti ti-eye"></i>
											</a>
										</td>
									</tr>
								<?php endforeach; ?>
								</tbody>
							</table>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
