<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"text" => t__('Edit Profile')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<?php _message(); ?>
				
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Edit Profile') ?>
						</h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('account.contact.update'); ?>" method="post">
							<?php _method('PATCH'); ?>
							<?php _csrf(); ?>
							<div class="row">
								<div class="col-md-6 mb-3">
									<label class="form-label" for="inputFirstName"><?php e__('First Name') ?>:</label>
									<input name="firstName" id="inputFirstName" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your first name.') ?>" value="<?php _old('firstName', $contactInfo["firstName"]); ?>">
								</div>
								<div class="col-md-6 mb-3">
									<label class="form-label" for="inputLastName"><?php e__('Last Name') ?>:</label>
									<input name="lastName" id="inputLastName" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your last name.') ?>" value="<?php _old('lastName', $contactInfo["lastName"]); ?>">
								</div>
							</div>
							<div class="mb-3">
								<label class="form-label" for="inputPhoneNumber"><?php e__('Phone Number') ?>:</label>
								<input name="phoneNumber" id="inputPhoneNumber" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your phone number.') ?>" value="<?php _old('phoneNumber', $contactInfo["phoneNumber"]); ?>">
							</div>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary"><?php e__('Save Changes') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
