<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"text" => t__('Credit History')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Credit History') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($logs) > 0): ?>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center">ID</th>
										<th class="text-center"><?php e__('Amount') ?></th>
										<th class="text-center"><?php e__('Type') ?></th>
										<th><?php e__('Date') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($logs as $log): ?>
										<tr>
											<td class="text-center">#<?php echo $log["id"]; ?></td>
											<td class="text-center">
												<?php if ($log["type"] == 1 || $log["type"] == 4 || $log["type"] == 6 || $log["type"] == 8): ?>
													<span class="text-success">+<?php echo money()->credits($log["price"]); ?></span>
												<?php else: ?>
													<span class="text-danger">-<?php echo money()->credits($log["price"]); ?></span>
												<?php endif; ?>
											</td>
											<td class="text-center">
												<?php if ($log["type"] == 1): ?>
													<span class="text-success">+<i class="fa fa-coins"></i></span>
												<?php elseif ($log["type"] == 2): ?>
													<span class="text-danger">-<i class="fa fa-coins"></i></span>
												<?php elseif ($log["type"] == 3): ?>
													<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer to %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
												<?php elseif ($log["type"] == 4): ?>
													<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer from %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?> "></i>
												<?php elseif ($log["type"] == 5): ?>
													<i class="fa fa-ticket-alt" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Wheel of Fortune (Ticket)') ?>"></i>
												<?php elseif ($log["type"] == 6): ?>
													<i class="fa fa-ticket-alt" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Wheel of Fortune (Prize)') ?>"></i>
												<?php elseif ($log["type"] == 7): ?>
													<i class="fa fa-store" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Bazaar (Purchase)') ?>"></i>
												<?php elseif ($log["type"] == 8): ?>
													<i class="fa fa-store" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Bazaar (Sell)') ?>"></i>
												<?php else: ?>
													<i class="fa fa-paper-plane"></i>
												<?php endif; ?>
											</td>
											<td><?php echo carbon($log["creationDate"])->intlFormat(); ?></td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
