<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"text" => t__('Orders')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Orders') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($orders) > 0): ?>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center">ID</th>
										<th><?php e__('Total') ?></th>
										<th class="text-center"><?php e__('Status') ?></th>
										<th><?php e__('Date') ?></th>
										<th class="text-end">&nbsp;</th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($orders as $order): ?>
										<tr>
											<td class="text-center">#<?php echo $order["id"]; ?></td>
											<td>
												<?php
													if ($order["type"] == 1) {
														echo money()->format($order["total"], false);
													} else {
														echo money()->real($order["earnings"], false);
													}
												?>
											</td>
											<td class="text-center">
												<?php if ($order["status"] == 1): ?>
													<span class="badge bg-success text-white"><?php e__('Success!') ?></span>
												<?php else: ?>
													<span class="badge bg-danger text-white"><?php e__('Error!') ?></span>
												<?php endif; ?>
											</td>
											<td><?php echo carbon($order["creationDate"])->intlFormat(); ?></td>
											<td class="text-end">
												<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('orders.show', ['id' => $order["id"]]); ?>" data-toggle="tooltip" data-placement="top" title="<?php e__('View') ?>">
													<i class="ti ti-eye"></i>
												</a>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
