<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Profile')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<?php _message(); ?>
				
				<div class="card">
					<div class="card-header d-block py-4">
						<div class="d-flex align-items-center justify-content-between">
							<div class="d-flex align-items-center gap-3">
								<?php $this->insert('components/avatar', [
									'avatar' => auth()->user()->avatar(),
									'username' => auth()->user()->displayName(),
									'class' => 'avatar avatar-lg rounded'
								]); ?>
								<div>
									<div class="fw-bold" style="line-height: 1"><?php echo auth()->user()->displayName(); ?></div>
									<div class="text-muted small"><?php echo auth()->user()->email(); ?></div>
								</div>
							</div>
							<a href="<?php echo url('account.settings.profile') ?>" class="btn btn-primary">
								<?php e__('Edit Profile') ?>
							</a>
						</div>
					</div>
					<div class="card-body">
						<div class="row">
							<?php
							$providerLabels = [
								'discord' => 'Discord ID',
								'steam' => 'Steam ID',
								'cfx' => 'Cfx.re ID',
								'minecraft' => 'UUID',
								'roblox' => 'Roblox ID'
							];
							?>
							<?php if ($login_provider != 'default'): ?>
								<div class="col-md-6 user-data border-end py-2">
									<i class="ti ti-at opacity-60 me-2"></i>
									<span class="me-1"><?php echo $providerLabels[$login_provider]; ?>:</span>
									<div class="text-muted">
										<?php echo auth()->user()->username(); ?>
									</div>
								</div>
							<?php endif; ?>
							<div class="col-md-6 user-data border-end py-2">
								<i class="ti ti-mail opacity-60 me-2"></i>
								<span class="me-1"><?php e__('Email') ?>:</span>
								<div class="text-muted">
									<?php echo auth()->user()->email(); ?>
								</div>
							</div>
							<div class="col-md-6 user-data border-end py-2">
								<i class="ti ti-wallet opacity-60 me-2"></i>
								<span class="me-1"><?php e__('Balance') ?>:</span>
								<span class="text-muted">
									<?php echo money()->format(auth()->user()->credits()); ?>
								</span>
							</div>
							<div class="col-md-6 user-data border-end py-2">
								<i class="ti ti-calendar opacity-60 me-2"></i>
								<span class="me-1"><?php e__('Reg. Date') ?>:</span>
								<span class="text-muted">
									<?php echo carbon(auth()->user()->createdAt())->intlFormat(); ?>
								</span>
							</div>
							<div class="col-md-6 user-data border-end py-2">
								<i class="ti ti-key opacity-60 me-2"></i>
								<span class="me-1"><?php e__('Role') ?>:</span>
								<span class="text-muted">
									<?php echo auth()->user()->primaryRoleName(); ?>
								</span>
							</div>
							<?php if (modules('tfa')->isActive()): ?>
								<div class="col-md-6 user-data border-end py-2">
									<i class="ti ti-shield-lock opacity-60 me-2"></i>
									<span class="me-1"><?php e__('Two Factor Authentication') ?>:</span>
									<span class="text-muted">
										<?php echo $tfaStatus ? t__('Enabled') : t__('Disabled'); ?>
									</span>
								</div>
							<?php endif; ?>
							<?php foreach ($customFields as $customField): ?>
								<div class="col-md-6 user-data border-end py-2">
									<i class="ti ti-info-circle opacity-60 me-2"></i>
									<span class="me-1"><?php echo $customField["name"] ?>:</span>
									<span class="text-muted">
										<?php echo $customField["value"]; ?>
									</span>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
				
				<?php if (modules("leaderboards")->isActive()): ?>
					<?php if (count($leaderboards) > 0): ?>
						<div class="card">
							<div class="card-body p-0">
								<nav>
									<div class="nav nav-tabs nav-fill">
										<?php foreach ($leaderboards as $leaderboardItem): ?>
											<a class="nav-item nav-link <?php _active($leaderboard !== null && $leaderboard["serverSlug"] == $leaderboardItem["serverSlug"]); ?>" href="?leaderboard=<?php echo $leaderboardItem["serverSlug"]; ?>">
												<?php echo $leaderboardItem["serverName"]; ?>
											</a>
										<?php endforeach; ?>
									</div>
								</nav>
								<div class="tab-content" id="nav-tabContent">
									<?php if ($leaderboard !== null): ?>
										<div class="tab-pane fade show active">
											<?php if ($leaderboard["userData"]): ?>
												<div class="table-responsive">
													<table class="table table-hover">
														<thead>
														<tr>
															<th><?php e__('Username') ?></th>
															<?php foreach ($leaderboard["tableTitles"] as $tableTitle): ?>
																<th class="text-center"><?php echo $tableTitle; ?></th>
															<?php endforeach; ?>
														</tr>
														</thead>
														<tbody id="leaderboards">
														<tr>
															<td>
																<div>
																	<?php echo $leaderboard["userData"][$leaderboard["usernameColumn"]]; ?>
																</div>
															</td>
															<?php foreach ($leaderboard["tableColumns"] as $tableColumn): ?>
																<td class="text-center"><?php echo $leaderboard["userData"][$tableColumn]; ?></td>
															<?php endforeach; ?>
														</tr>
														</tbody>
													</table>
												</div>
											<?php else: ?>
												<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
											<?php endif; ?>
										</div>
									<?php else: ?>
										<div class="tab-pane fade show active">
											<div class="py-4 px-4 d-flex justify-content-center align-items-center gap-2">
												<i class="ti ti-eye"></i>
												<?php e__('Please select a leaderboard to view.') ?>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
				
				<?php if (modules('support')->isActive()): ?>
					<div class="card">
						<div class="card-header">
							<div class="card-title justify-content-between d-flex w-100">
								<div><?php e__('Tickets') ?></div>
								<a href="<?php echo url('support.tickets.index') ?>" class="small"><?php e__('View All') ?></a>
							</div>
						</div>
						<div class="card-body p-0">
							<?php if (count($tickets) > 0): ?>
								<div class="table-responsive">
									<table class="table table-hover">
										<thead>
										<tr>
											<th class="text-center" style="width: 40px;">ID</th>
											<th><?php e__('Title') ?></th>
											<th><?php e__('Category') ?></th>
											<th><?php e__('Last Updated') ?></th>
											<th class="text-center"><?php e__('Status') ?></th>
											<th class="text-center"> </th>
										</tr>
										</thead>
										<tbody>
										<?php foreach ($tickets as $ticket): ?>
											<tr>
												<td class="text-center" style="width: 40px;">
													<a href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>/">
														#<?php echo $ticket["id"]; ?>
													</a>
												</td>
												<td>
													<a href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>/">
														<?php echo $ticket["title"]; ?>
													</a>
												</td>
												<td>
													<?php echo $ticket["categoryName"]; ?>
												</td>
												<td>
													<?php echo carbon($ticket["updateDate"])->diffForHumans(); ?>
												</td>
												<td class="text-center">
													<?php if ($ticket["statusID"] == 1): ?>
														<span class="badge text-white bg-info"><?php e__('Open') ?></span>
													<?php elseif ($ticket["statusID"] == 2): ?>
														<span class="badge text-white bg-success"><?php e__('Answered') ?></span>
													<?php elseif ($ticket["statusID"] == 3): ?>
														<span class="badge text-white bg-warning"><?php e__('User-Reply') ?></span>
													<?php elseif ($ticket["statusID"] == 4): ?>
														<span class="badge text-white bg-danger"><?php e__('Closed') ?></span>
													<?php else: ?>
														<span class="badge text-white bg-danger"><?php e__('Error') ?></span>
													<?php endif; ?>
												</td>
												<td class="text-center">
													<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('View') ?>">
														<i class="ti ti-eye"></i>
													</a>
												</td>
											</tr>
										<?php endforeach; ?>
										</tbody>
									</table>
								</div>
							<?php else: ?>
								<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
				
				<?php if (modules('store')->isActive()): ?>
					<div class="card">
						<div class="card-header">
							<div class="card-title justify-content-between d-flex w-100">
								<div><?php e__('Orders') ?></div>
								<a href="<?php echo url('account.orders') ?>" class="small"><?php e__('View All') ?></a>
							</div>
						</div>
						<div class="card-body p-0">
							<?php if (count($orders) > 0): ?>
								<div class="table-responsive">
									<table class="table table-hover">
										<thead>
										<tr>
											<th class="text-center">ID</th>
											<th><?php e__('Total') ?></th>
											<th class="text-center"><?php e__('Status') ?></th>
											<th><?php e__('Date') ?></th>
											<th class="text-end">&nbsp;</th>
										</tr>
										</thead>
										<tbody>
										<?php foreach ($orders as $order): ?>
											<tr>
												<td class="text-center">#<?php echo $order["id"]; ?></td>
												<td>
													<?php
														if ($order["type"] == 1) {
															echo money()->format($order["total"], false);
														} else {
															echo money()->real($order["earnings"], false);
														}
													?>
												</td>
												<td class="text-center">
													<?php if ($order["status"] == 1): ?>
														<span class="badge bg-success text-white"><?php e__('Success!') ?></span>
													<?php else: ?>
														<span class="badge bg-danger text-white"><?php e__('Error!') ?></span>
													<?php endif; ?>
												</td>
												<td><?php echo carbon($order["creationDate"])->intlFormat(); ?></td>
												<td class="text-end">
													<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('orders.show', ['id' => $order["id"]]); ?>" data-toggle="tooltip" data-placement="top" title="<?php e__('View') ?>">
														<i class="ti ti-eye"></i>
													</a>
												</td>
											</tr>
										<?php endforeach; ?>
										</tbody>
									</table>
								</div>
							<?php else: ?>
								<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>
				
				<?php if (modules('credit')->isActive()): ?>
					<div class="card">
						<div class="card-header">
							<div class="card-title justify-content-between d-flex w-100">
								<div><?php e__('Credit History') ?></div>
								<a href="<?php echo url('account.credit-history') ?>" class="small"><?php e__('View All') ?></a>
							</div>
						</div>
						<div class="card-body p-0">
							<?php if (count($creditLogs) > 0): ?>
								<div class="table-responsive" <?php echo (count($creditLogs) > 10) ? 'style="height: 400px; overflow:auto;"' : null; ?>>
									<table class="table table-hover">
										<thead>
										<tr>
											<th class="text-center">ID</th>
											<th class="text-center"><?php e__('Amount') ?></th>
											<th class="text-center"><?php e__('Type') ?></th>
											<th><?php e__('Date') ?></th>
										</tr>
										</thead>
										<tbody>
										<?php foreach ($creditLogs as $creditLog): ?>
											<tr>
												<td class="text-center">#<?php echo $creditLog["id"]; ?></td>
												<td class="text-center">
													<?php if ($creditLog["type"] == 1 || $creditLog["type"] == 4 || $creditLog["type"] == 6 || $creditLog["type"] == 8): ?>
														<span class="text-success">+<?php echo money()->credits($creditLog["price"]); ?></span>
													<?php else: ?>
														<span class="text-danger">-<?php echo money()->credits($creditLog["price"]); ?></span>
													<?php endif; ?>
												</td>
												<td class="text-center">
													<?php if ($creditLog["type"] == 1): ?>
														<span class="text-success">+<i class="fa fa-coins"></i></span>
													<?php elseif ($creditLog["type"] == 2): ?>
														<span class="text-danger">-<i class="fa fa-coins"></i></span>
													<?php elseif ($creditLog["type"] == 3): ?>
														<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer to %username%', ['%username%' => $creditLog["otherAccountDisplayName"]]) ?>"></i>
													<?php elseif ($creditLog["type"] == 4): ?>
														<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer from %username%', ['%username%' => $creditLog["otherAccountDisplayName"]]) ?> "></i>
													<?php elseif ($creditLog["type"] == 5): ?>
														<i class="fa fa-ticket-alt" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Wheel of Fortune (Ticket)') ?>"></i>
													<?php elseif ($creditLog["type"] == 6): ?>
														<i class="fa fa-ticket-alt" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Wheel of Fortune (Prize)') ?>"></i>
													<?php elseif ($creditLog["type"] == 7): ?>
														<i class="fa fa-store" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Bazaar (Purchase)') ?>"></i>
													<?php elseif ($creditLog["type"] == 8): ?>
														<i class="fa fa-store" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Bazaar (Sell)') ?>"></i>
													<?php else: ?>
														<i class="fa fa-paper-plane"></i>
													<?php endif; ?>
												</td>
												<td><?php echo carbon($creditLog["creationDate"])->intlFormat(); ?></td>
											</tr>
										<?php endforeach; ?>
										</tbody>
									</table>
								</div>
							<?php else: ?>
								<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
							<?php endif; ?>
						</div>
					</div>
				<?php endif; ?>

			</div>
		</div>
	</div>
</section>
