<?php $this->layout('layouts/main'); ?>

<?php $this->push('scripts'); ?>
<script>
	document.getElementById("inputAvatar").addEventListener("change", function() {
		const changeAvatarButton = document.getElementById("changeAvatarButton");
		
		if (this.files.length > 0) {
			changeAvatarButton.disabled = true;
			changeAvatarButton.classList.add("disabled");
			changeAvatarButton.textContent = "<?php e__('Uploading...') ?>";
			
			document.getElementById("changeAvatarForm").submit();
		}
	});
</script>
<?php $this->end(); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"url" => url("account.profile.index"),
						"text" => t__('Settings')
					],
					[
						"text" => t__('Edit Profile')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<?php _message(); ?>
				
				<?php if (settings('allowCustomAvatars')): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title">
								<?php e__('Avatar') ?>
							</h2>
						</div>
						<div class="card-body">
							<div class="d-flex flex-column flex-lg-row align-items-center gap-3">
								<div>
									<?php $this->insert('components/avatar', [
										'avatar' => auth()->user()->avatar(),
										'username' => auth()->user()->displayName(),
										'class' => 'avatar avatar-150px rounded',
										'size' => '150px'
									]); ?>
								</div>
								<div>
									<div class="d-flex justify-content-center justify-content-lg-start align-items-center gap-1">
										<form id="changeAvatarForm" action="<?php echo url('account.settings.profile.upload-avatar'); ?>" method="post" enctype="multipart/form-data">
											<?php _csrf(); ?>
											<input type="file" name="avatar" accept="image/png, image/gif, image/jpg, image/jpeg" id="inputAvatar" class="d-none">
											<label for="inputAvatar" id="changeAvatarButton" class="btn btn-primary"><?php e__('Change Avatar') ?></label>
										</form>
										<form data-toggle="form-submit-with-loader" action="<?php echo url('account.settings.profile.remove-avatar'); ?>" method="post" enctype="multipart/form-data">
											<?php _csrf(); ?>
											<button type="submit" onclick="return confirm('<?php e__('Are you sure you want to delete?') ?>')" class="btn btn-danger w-full"><?php e__('Remove Avatar') ?></button>
										</form>
									</div>
									<div class="mt-2 text-center text-lg-start">
										<small class="text-muted">
											<?php e__('Allowed image formats: JPG, PNG, and GIF.') ?>
											<br>
											<?php e__('Maximum upload size: 2 MB, recommended dimensions: 256x256 pixels.') ?>
										</small>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>
				
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Edit Profile') ?>
						</h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('account.settings.profile.update-details'); ?>" method="post">
							<?php _csrf(); ?>
							<div class="row">
								<div class="col-md-6 mb-3">
									<label class="form-label" for="inputFirstName"><?php e__('First Name') ?>:</label>
									<input name="firstName" id="inputFirstName" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your first name.') ?>" value="<?php _old('firstName', $contactInfo["firstName"]); ?>">
								</div>
								<div class="col-md-6 mb-3">
									<label class="form-label" for="inputLastName"><?php e__('Last Name') ?>:</label>
									<input name="lastName" id="inputLastName" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your last name.') ?>" value="<?php _old('lastName', $contactInfo["lastName"]); ?>">
								</div>
							</div>
							<div class="mb-3">
								<label class="form-label" for="inputPhoneNumber"><?php e__('Phone Number') ?>:</label>
								<input name="phoneNumber" id="inputPhoneNumber" class="form-control rounded" type="text" required="" placeholder="<?php e__('Enter your phone number.') ?>" value="<?php _old('phoneNumber', $contactInfo["phoneNumber"]); ?>">
							</div>
							<?php if (count($customFields) > 0): ?>
								<?php foreach ($customFields as $customField): ?>
									<div class="mb-3">
										<label class="form-label" for="inputCustom-<?php echo $customField["id"]; ?>">
											<?php echo $customField["name"] ?>:
											<?php if ($customField["description"]): ?>
												<i class="fa fa-info-circle text-primary" data-bs-toggle="tooltip" data-bs-placement="right" title="<?php echo $customField["description"]; ?>"></i>
											<?php endif; ?>
										</label>
										<input
											name="customfield__<?php echo $customField["id"]; ?>"
											class="form-control"
											type="text"
											id="inputCustom-<?php echo $customField["id"]; ?>"
											value="<?php _old('customfield__'.$customField["id"], $customField["value"]); ?>"
											<?php echo $customField["isRequired"] ? 'required' : null; ?>
										>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary"><?php e__('Save Changes') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
