<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"url" => url("account.profile.index"),
						"text" => t__('Settings')
					],
					[
						"text" => t__('Linked Accounts')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<?php _message(); ?>
				
				<?php foreach ($providers as $provider): ?>
					<div class="card">
						<div class="card-header border-0 d-block py-4">
							<div class="d-flex justify-content-between align-items-center">
								<div class="d-flex align-items-center gap-3">
									<img src="<?php echo $provider["icon"]; ?>" alt="<?php echo $provider["name"]; ?>" width="40px">
									<div>
										<h2 class="card-title mb-0">
											<?php e__($provider["name"]); ?>
										</h2>
										<p class="card-subtitle small">
											<?php if ($provider["isLinked"]): ?>
											  <?php e__('Linked to: %name%', ['%name%' => $provider["connection"]["displayName"]]); ?>
											<?php else: ?>
												<?php e__('Not linked to any account.') ?>
											<?php endif; ?>
										</p>
									</div>
								</div>
								<div>
									<?php if ($provider["isLinked"]): ?>
										<form data-toggle="form-submit-with-loader" action="<?php echo url('account-linking.unlink', ['provider' => $provider["slug"]]) ?>" method="post">
											<?php _csrf(); ?>
											<button type="submit" class="btn btn-danger" onclick="return confirm('<?php e__('Are you sure want to unlink your %provider% account?', ['%provider%' => t__($provider["name"])]) ?>');"><?php e__('Unlink Account') ?></button>
										</form>
									<?php else: ?>
										<a href="<?php echo url('account-linking.link', ['provider' => $provider["slug"]]) ?>" class="btn btn-primary" type="submit"><?php e__('Link Account') ?></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</section>
