<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"url" => url("account.profile.index"),
						"text" => t__('Settings')
					],
					[
						"text" => t__('Security')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<?php _message(); ?>
				
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Change Email') ?>
						</h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('account.settings.security.change-email') ?>" method="post">
							<?php _csrf(); ?>
							<div class="mb-3">
								<label class="form-label" for="email"><?php e__('Email') ?>:</label>
								<input name="email" id="email" class="form-control rounded" type="email" required value="<?php _old('email', auth()->user()->email()); ?>">
							</div>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary"><?php e__('Change Email') ?></button>
							</div>
						</form>
					</div>
				</div>
				
				<?php if ($login_provider == 'default'): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title">
								<?php e__('Change Password') ?>
							</h2>
						</div>
						<div class="card-body">
							<form data-toggle="form-submit-with-loader" action="<?php echo url('account.settings.security.change-password') ?>" method="post">
								<?php _csrf(); ?>
								<div class="mb-3">
									<label class="form-label" for="currentPassword"><?php e__('Current Password') ?>:</label>
									<input name="currentPassword" id="currentPassword" class="form-control" type="password" placeholder="<?php e__('Enter your current password.') ?>" required>
								</div>
								<hr class="my-4">
								<div class="mb-3">
									<label class="form-label" for="password"><?php e__('New Password') ?>:</label>
									<input name="password" class="form-control" id="password" type="password" placeholder="********" required>
								</div>
								<div class="mb-3">
									<label class="form-label" for="passwordRe"><?php e__('Confirm New Password') ?>:</label>
									<input name="passwordRe" id="passwordRe" class="form-control" type="password" placeholder="********" required>
								</div>
								<div class="d-flex justify-content-end">
									<button type="submit" class="btn btn-primary"><?php e__('Change Password') ?></button>
								</div>
							</form>
						</div>
					</div>
				<?php endif; ?>
				
				<?php if (modules('tfa')->isActive()): ?>
					<div class="card">
						<div class="card-header d-block py-4">
							<div class="d-flex justify-content-between align-items-center">
								<div>
									<h2 class="card-title">
										<?php e__('Two Factor Authentication') ?>
									</h2>
									<p class="mb-0 text-muted">
										<?php e__('Two-factor authentication adds an extra layer of security to your account.') ?>
									</p>
								</div>
								<div>
										<form data-toggle="form-submit-with-loader" action="<?php echo url('account.settings.security.toggle-tfa') ?>" method="post">
											<?php _csrf(); ?>
											<?php if ($tfaStatus): ?>
												<button type="submit" class="btn btn-danger"><?php e__('Disable') ?></button>
											<?php else: ?>
												<button type="submit" class="btn btn-primary"><?php e__('Enable') ?></button>
											<?php endif; ?>
										</form>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
