<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("account.profile.index"),
						"text" => t__('Profile')
					],
					[
						"text" => t__('Subscriptions')
					]
				]]) ?>
			</div>
			<div class="col-lg-3 mb-4 mb-lg-0">
				<?php $this->insert('components/sidebar-profile-card') ?>
			</div>
			
			<div class="col-md-9">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Subscriptions') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($subscriptions) > 0): ?>
							<table class="table table-hover">
								<thead>
								<tr>
									<th class="text-center" style="width: 40px;">ID</th>
									<th><?php e__('Product') ?></th>
									<th><?php e__('Duration') ?></th>
									<?php if (modules('tebex_store')->isActive()): ?>
										<th class="text-end">&nbsp;</th>
									<?php endif; ?>
								</tr>
								</thead>
								<tbody>
								<?php foreach ($subscriptions as $subscription): ?>
									<tr>
										<td class="text-center" style="width: 40px;">
											#<?php echo $subscription["id"]; ?>
										</td>
										<td>
											<?php echo $subscription["productName"]; ?>
										</td>
										<td>
											<?php if ($subscription["endsAt"] == '1000-01-01 00:00:00'): ?>
												<?php e__('Lifetime') ?>
											<?php else: ?>
												<?php if ($subscription["endsAt"] > date('Y-m-d H:i:s')): ?>
													<?php e__('%day% day(s)', ['%day%' => carbon($subscription["endsAt"])->diffInDays()]) ?>
												<?php else: ?>
													<?php e__('Expired') ?>
												<?php endif; ?>
											<?php endif; ?>
										</td>
										<?php if (modules('tebex_store')->isActive()): ?>
											<td class="text-end">
												<a target="_blank" class="btn btn-primary btn-icon btn-sm" href="https://checkout.tebex.io/payment-history/recurring-payments" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Manage') ?>">
													<i class="ti ti-eye"></i>
												</a>
											</td>
										<?php endif; ?>
									</tr>
								<?php endforeach; ?>
								</tbody>
							</table>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
