<?php $this->layout('layouts/main'); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Application')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php if ($form["isAppliable"]): ?>
					<?php _message(); ?>
					<div class="card">
						<div class="card-header">
							<div>
								<h4 class="card-title"><?php echo $form["title"]; ?></h4>
								<div class="ck-content">
									<?php echo $form["description"]; ?>
								</div>
							</div>
						</div>
						<div class="card-body">
							<form data-toggle="form-submit-with-loader" action="<?php echo url('applications.forms.apply', ['id' => $form["id"]]) ?>" method="post">
								<?php _csrf(); ?>
								<?php foreach ($form["questions"] as $question): ?>
									<div class="mb-3">
										<label for="input-<?php echo $question["id"]; ?>" class="form-label">
											<?php echo $question["question"]; ?>
										</label>
										<?php if ($question["type"] == 1): ?>
											<input type="text" id="input-<?php echo $question["id"]; ?>" class="form-control" name="field-<?php echo $question["id"]; ?>" required>
										<?php endif; ?>
										<?php if ($question["type"] == 2): ?>
											<textarea id="input-<?php echo $question["id"]; ?>" class="form-control" name="field-<?php echo $question["id"]; ?>" rows="3" required></textarea>
										<?php endif; ?>
										<?php if ($question["type"] == 3 || $question["type"] == 4): ?>
											<select id="input-<?php echo $question["id"]; ?>" class="form-control" name="field-<?php echo $question["id"].($question["type"] == 4 ? "[]" : null); ?>" data-toggle="select2" required <?php echo ($question["type"] == 4) ? 'multiple="multiple"' : null ?>>
												<?php $variables = explode(",", $question["variables"]); ?>
												<?php foreach ($variables as $variable): ?>
													<?php $variable = trim($variable); ?>
													<?php if ($variable != ''): ?>
														<option value="<?php echo $variable; ?>"><?php echo $variable; ?></option>
													<?php endif; ?>
												<?php endforeach; ?>
											</select>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
								<div class="d-flex justify-content-end">
									<button type="submit" class="btn btn-primary" name="apply"><?php e__('Send') ?></button>
								</div>
							</form>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__("You cannot apply while you have an active application.")]) ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
