<?php $this->layout('layouts/main'); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Application')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<div class="card">
					<div class="card-header justify-content-between">
						<h5 class="card-title mb-0"><?php echo substr($application["title"], 0, 50); ?></h5>
						<div>
							<?php if ($application["status"] == 0): ?>
								<span class="badge bg-danger text-white" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Status') ?>"><?php e__('Rejected') ?></span>
							<?php elseif ($application["status"] == 1): ?>
								<span class="badge bg-success text-white" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Status') ?>""><?php e__('Approved') ?></span>
							<?php elseif ($application["status"] == 2): ?>
								<span class="badge bg-warning text-white" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Status') ?>""><?php e__('Pending Approval') ?></span>
							<?php else: ?>
								<span class="badge bg-danger text-white" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Status') ?>""><?php e__('Error!') ?></span>
							<?php endif; ?>
						</div>
					</div>
					<div class="card-body pb-0">
						<?php if ($application["reason"] != ''): ?>
							<div>
								<div class="form-label mb-1">
									<?php e__('Reason'); ?>:
								</div>
								<p><?php echo $application["reason"]; ?></p>
							</div>
						<?php endif; ?>
						<?php foreach ($application["answers"] as $answer): ?>
							<div>
								<div class="form-label mb-1">
									<?php echo $answer["question"]; ?>
								</div>
								<p>
									<?php echo $answer["answer"]; ?>
								</p>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
