<?php $this->layout('layouts/auth'); ?>

<?php if (recaptcha()->isEnabled('forgot_password')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Recover Account') ?></h2>
		<p class="text-muted mb-5 text-center"><?php e__('Submit a reset request to access your account.') ?></p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('auth.forgot-password') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3">
				<label for="username" class="form-label"><?php e__('Username') ?></label>
				<input type="text" name="username" id="username" class="form-control" required value="<?php _old('username') ?>">
			</div>
			<div class="mb-3">
				<label for="email" class="form-label"><?php e__('Email') ?></label>
				<input type="email" name="email" id="email" class="form-control" required value="<?php _old('email') ?>">
			</div>
			<?php if (recaptcha()->isEnabled('forgot_password')) : ?>
				<div class="mt-3 d-flex justify-content-center">
					<?php echo recaptcha()->getHTML() ?>
				</div>
			<?php endif; ?>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Send') ?>
				</button>
			</div>
		</form>
	</div>
</div>
<div class="text-center text-secondary mt-3">
	<?php e__("Remember your password?") ?> <a href="<?php echo url('auth.login') ?>"><?php e__('Login') ?></a>
</div>