<?php $this->layout('layouts/auth'); ?>

<?php if (recaptcha()->isEnabled('login')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Login') ?></h2>
		<p class="text-muted mb-5 text-center"><?php e__('Sign in to access your account.') ?></p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('auth.login') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3">
				<label for="username" class="form-label"><?php e__('Username') ?></label>
				<input type="text" name="username" id="username" class="form-control" required value="<?php _old('username') ?>">
			</div>
			<div class="mb-2">
				<label for="password" class="form-label">
					<?php e__('Password') ?>
					<span class="form-label-description">
						<a href="<?php echo url('auth.forgot-password') ?>" tabindex="-1">
							<?php e__('Forgot Password?') ?>
						</a>
					</span>
				</label>
				<div class="input-group input-group-flat">
					<input type="password" name="password" id="password" class="form-control" required>
					<span class="input-group-text">
						<a href="#" class="link-secondary toggle-password no-underline" data-target="#password" tabindex="-1">
							<i class="ti ti-eye"></i>
						</a>
					</span>
				</div>
			</div>
			<div class="mb-2">
				<label class="form-check">
					<input type="checkbox" class="form-check-input" name="rememberMe" />
					<span class="form-check-label">
						<?php e__('Remember me') ?>
					</span>
				</label>
			</div>
			<?php if (recaptcha()->isEnabled('login')) : ?>
				<div class="mt-3 d-flex justify-content-center">
					<?php echo recaptcha()->getHTML() ?>
				</div>
			<?php endif; ?>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Login') ?>
				</button>
			</div>
		</form>
	</div>
	<?php if (modules('discord')->isActive()): ?>
		<div class="hr-text">
			<?php e__('or') ?>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col">
					<a href="<?php echo url('discord.login') ?>" class="btn w-100">
						<i class="ti ti-brand-discord icon text-primary"></i>
						<?php e__('Sign in with Discord') ?>
					</a>
				</div>
			</div>
		</div>
	<?php endif; ?>
	<?php if (count($providers) > 0): ?>
		<div class="hr-text">
			<?php e__('or') ?>
		</div>
		<div class="card-body">
			<div class="row">
				<?php foreach ($providers as $provider): ?>
					<div class="col-md-12 mb-2">
						<a href="<?php echo url('account-linking.login', ['provider' => $provider["slug"]]) ?>" class="btn w-100">
							<img class="me-2" src="<?php echo $provider["icon"]; ?>" alt="<?php echo $provider["name"]; ?>" width="20px">
							<?php e__('Sign in with %provider%', ['%provider%' => t__($provider["name"])]) ?>
						</a>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	<?php endif; ?>
</div>

<?php if (settings('registrationStatus') == 1): ?>
	<div class="text-center text-secondary mt-3">
		<?php e__("Don't have an account?") ?> <a href="<?php echo url('auth.register') ?>"><?php e__('Register') ?></a>
	</div>
<?php endif; ?>