<?php $this->layout('layouts/auth'); ?>

<?php if (recaptcha()->isEnabled('register')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Register') ?></h2>
		<p class="text-muted mb-5 text-center"><?php e__('Sign up to join our server.') ?></p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('auth.register') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3">
				<label for="username" class="form-label"><?php e__('Username') ?></label>
				<input type="text" name="username" id="username" class="form-control" required value="<?php _old('username') ?>">
			</div>
			<div class="mb-3">
				<label for="email" class="form-label"><?php e__('Email') ?></label>
				<input type="email" name="email" id="email" class="form-control" required value="<?php _old('email') ?>">
			</div>
			<div class="mb-3">
				<label for="password" class="form-label"><?php e__('Password') ?></label>
				<div class="input-group input-group-flat">
					<input type="password" name="password" id="password" class="form-control" required>
					<span class="input-group-text">
						<a href="#" class="link-secondary toggle-password no-underline" data-target="#password" tabindex="-1">
							<i class="ti ti-eye"></i>
						</a>
					</span>
				</div>
			</div>
			<div class="mb-3">
				<label for="passwordRe" class="form-label"><?php e__('Confirm Password') ?></label>
				<div class="input-group input-group-flat">
					<input type="password" name="passwordRe" id="passwordRe" class="form-control" required>
					<span class="input-group-text">
						<a href="#" class="link-secondary toggle-password no-underline" data-target="#passwordRe" tabindex="-1">
							<i class="ti ti-eye"></i>
						</a>
					</span>
				</div>
			</div>
			<?php if (recaptcha()->isEnabled('register')) : ?>
				<div class="mt-3 d-flex justify-content-center">
					<?php echo recaptcha()->getHTML() ?>
				</div>
			<?php endif; ?>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Register') ?>
				</button>
			</div>
		</form>
	</div>
</div>
<div class="text-center text-secondary mt-3">
	<?php e__("Do you have an account?") ?> <a href="<?php echo url('auth.login') ?>"><?php e__('Login') ?></a>
</div>