<?php $this->layout('layouts/auth'); ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Change Password') ?></h2>
		<p class="text-muted mb-5 text-center"><?php e__('Change your password to access your account.') ?></p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('auth.reset-password') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3">
				<label for="password" class="form-label"><?php e__('New Password') ?></label>
				<div class="input-group input-group-flat">
					<input type="password" name="password" id="password" class="form-control" required>
					<span class="input-group-text">
						<a href="#" class="link-secondary toggle-password no-underline" data-target="#password" tabindex="-1">
							<i class="ti ti-eye"></i>
						</a>
					</span>
				</div>
			</div>
			<div class="mb-3">
				<label for="passwordRe" class="form-label"><?php e__('Confirm New Password') ?></label>
				<div class="input-group input-group-flat">
					<input type="password" name="passwordRe" id="passwordRe" class="form-control" required>
					<span class="input-group-text">
						<a href="#" class="link-secondary toggle-password no-underline" data-target="#passwordRe" tabindex="-1">
							<i class="ti ti-eye"></i>
						</a>
					</span>
				</div>
			</div>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Change Password') ?>
				</button>
			</div>
		</form>
	</div>
</div>
<div class="text-center text-secondary mt-3">
	<?php e__("Do you have an account?") ?> <a href="<?php echo url('auth.login') ?>"><?php e__('Login') ?></a>
</div>