<?php $this->layout('layouts/main'); ?>

<section class="section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Bazaar')
					]
				]]) ?>
			</div>
		</div>
		
		<div class="row">
			<?php if (count($servers) > 0): ?>
				<?php foreach ($servers as $server): ?>
					<div class="col-md-3">
						<a class="card" href="<?php echo url('bazaar.servers.show', ['slug' => $server["slug"]]) ?>">
							<img class="card-img-top lazyload" data-src="<?php echo $server["image"] ?>" src="/assets/core/images/loaders/server.png">
							<div class="card-body">
								<h3 class="card-title">
									<?php echo $server["name"]; ?>
								</h3>
							</div>
						</a>
					</div>
				<?php endforeach; ?>
			<?php else: ?>
				<div class="col-md-12">
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No server were found!')]); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>
