<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('bazaar.manage.index'),
						"text" => t__('Bazaar Storage')
					],
					[
						"text" => t__('Sell')
					]
				]]) ?>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="text-center py-3">
						<img width="64px" src="<?php echo $item["image"]; ?>" />
					</div>
					<div class="card-body d-flex flex-column row-gap-2">
						<div>
							<div class="form-label mb-0"><?php e__('Item') ?>:</div>
							<div>
								<?php echo $item["coloredName"] ?>
							</div>
						</div>
						<div>
							<div class="form-label mb-0"><?php e__('Amount') ?>:</div>
							<div>
								<?php echo $item["amount"]; ?>
							</div>
						</div>
						<div>
							<div class="form-label mb-0"><?php e__('Durability') ?>:</div>
							<div>
								<?php echo $item["durability"]; ?>
							</div>
						</div>
						<div>
							<div class="form-label mb-0"><?php e__('Server') ?>:</div>
							<div>
								<?php echo $item["serverName"]; ?>
							</div>
						</div>
						<?php if ($item["enchantments"] != null && $item["enchantments"] != ""): ?>
							<div>
								<div class="form-label mb-0"><?php e__('Enchantments') ?>:</div>
								<div>
									<?php foreach ($item["enchantments"] as $enchantment): ?>
									  <?php echo "* Lvl. ".$enchantment["lvl"]." - ".$enchantment["enchantment"]."<br>"; ?>
									<?php endforeach; ?>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($item["lore"] != null && $item["lore"] != ""): ?>
							<div>
								<div class="form-label mb-0"><?php e__('Lore') ?>:</div>
								<div style="color: #fff; padding: 15px; background-color: #0F000F; border: 3px solid #535353;">
									<?php echo $item["coloredLore"]; ?>
								</div>
							</div>
						<?php endif; ?>
						
						<?php if ($item["price"] > 0): ?>
							<form data-toggle="form-submit-with-loader" action="<?php echo url('bazaar.manage.remove', ['id' => $item["id"]]) ?>" method="post">
								<?php _csrf(); ?>
								<button type="submit" class="btn btn-danger w-100 mt-2" onclick="return confirm('<?php e__('Are you sure you want to remove this item from the bazaar?') ?>')">
									<?php e__('Remove from Bazaar') ?>
								</button>
							</form>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Sell') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('bazaar.manage.sell', ['id' => $item["id"]]) ?>" method="post">
							<?php _csrf(); ?>
							<div class="mb-3">
								<label for="price" class="form-label"><?php e__('Price') ?>:</label>
								<input type="number" step="any" name="price" id="price" class="form-control" value="<?php echo $item["price"] == 0 ? null : $item["price"]; ?>">
							</div>
							<div class="mb-3">
								<label for="description" class="form-label"><?php e__('Description') ?>:</label>
								<textarea name="description" id="description" class="form-control"><?php echo $item["description"]; ?></textarea>
							</div>
							<?php if ($item["sold"] == 0): ?>
								<div class="d-flex justify-content-end">
									<button type="submit" class="btn btn-primary">
										<?php echo $item["price"] == 0 ? t__('Sell') : t__('Update') ?>
									</button>
								</div>
							<?php endif; ?>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>