<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('bazaar.index'),
						"text" => t__('Bazaar')
					],
					[
						"text" => t__('Bazaar Storage')
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<?php if (modules('bazaar')->settings('commission') > 0): ?>
					<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('You will be charged %commission%% commission per sale!', ['%commission%' => modules('bazaar')->settings('commission')])]); ?>
				<?php endif; ?>
				<?php if (count($items) > 0): ?>
					<div class="card">
						<div class="card-header justify-content-between">
							<h2 class="card-title"><?php e__('Bazaar Storage') ?></h2>
							<a href="<?php echo url('bazaar.help') ?>"><?php e__('Help') ?></a>
						</div>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center" style="width: 40px;">#ID</th>
										<th><?php e__('Item') ?></th>
										<th><?php e__('Server') ?></th>
										<th><?php e__('Price') ?></th>
										<th><?php e__('Status') ?></th>
										<th><?php e__('Date') ?></th>
										<th class="text-end">&nbsp;</th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($items as $item): ?>
										<tr>
											<td class="text-center" style="width: 40px;">
												#<?php echo $item["id"]; ?>
											</td>
											<td>
												<?php echo $item["coloredName"] ?>
											</td>
											<td>
												<?php echo $item["serverName"]; ?>
											</td>
											<td>
												<?php echo $item["price"] == 0 ? "-" : money()->credits($item["price"]); ?>
											</td>
											<td>
												<?php if ($item["sold"] == 0): ?>
													<?php if ($item["price"] == 0): ?>
														<span class="badge text-white bg-warning"><?php e__('In Storage') ?></span>
													<?php else: ?>
														<span class="badge text-white bg-success"><?php e__('On Sale') ?></span>
													<?php endif; ?>
												<?php else: ?>
													<span class="badge text-white bg-danger"><?php e__('Sold') ?></span>
												<?php endif; ?>
											</td>
											<td>
												<?php echo carbon($item["creationDate"])->intlFormat(); ?>
											</td>
											<td class="text-end">
												<?php if ($item["sold"] == 0): ?>
													<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('bazaar.manage.edit', ['id' => $item["id"]]); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Edit') ?>">
														<i class="ti ti-edit"></i>
													</a>
												<?php endif; ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No items found in your storage!')]); ?>
				<?php endif; ?>
			</div>
			<div class="col-md-4">
				<div class="row">
					<div class="col-md-12">
						<div class="card">
							<div class="card-header justify-content-between">
								<h2 class="card-title fs-100"><?php e__('Bazaar History') ?></h2>
								<a href="<?php echo url('account.profile.index') ?>" class="small"><?php e__('View All') ?></a>
							</div>
							<?php if (count($logs) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Item') ?></th>
												<th class="text-end">&nbsp;</th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($logs as $log): ?>
												<tr>
													<td><?php echo $log["coloredItemName"] ?></td>
													<td class="text-end">
														<?php if ($log["type"] == 0): ?>
															<span class="text-danger" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Purchase') ?>">-<?php echo money()->credits($log["itemPrice"]); ?></span>
														<?php elseif ($log["type"] == 1): ?>
															<span class="text-success" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Sell') ?>">+<?php echo money()->credits($log["itemPrice"]); ?></span>
														<?php else: ?>
															<i class="fa fa-check"></i>
														<?php endif; ?>
													</td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else: ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</section>