<?php $this->layout('layouts/main') ?>
<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('bazaar.index'),
						"text" => t__("Bazaar")
					],
					[
						"url" => url('bazaar.servers.show', ['slug' => $product["server"]["slug"]]),
						"text" => $product["server"]["name"]
					],
					[
						"text" => $product["name"]
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-body py-4">
						<div class="row">
							<div class="col-md-4">
								<img data-src="<?php echo $product["image"] ?>" alt="" class="lazyload w-100" src="/assets/core/images/loaders/store.png">
							</div>
							<div class="col-md-8">
								<div>
									<p class="mb-0 opacity-75 small text-uppercase fw-semibold"><?php echo $product["server"]["name"] ?></p>
									<h2 class="h2 mb-3"><?php echo $product["coloredName"]; ?></h2>
								</div>
								<div class="d-flex flex-column gap-3">
									<div>
										<div class="form-label mb-0"><?php e__('Item') ?>:</div>
										<div>
											<?php echo $product["itemID"] ?>
										</div>
									</div>
									<div>
										<div class="form-label mb-0"><?php e__('Amount') ?>:</div>
										<div>
											<?php echo $product["amount"]; ?>
										</div>
									</div>
									<div>
										<div class="form-label mb-0"><?php e__('Durability') ?>:</div>
										<div>
											<?php echo $product["durability"]; ?>
										</div>
									</div>
									<div>
										<div class="form-label mb-0"><?php e__('Server') ?>:</div>
										<div>
											<?php echo $product["server"]["name"]; ?>
										</div>
									</div>
									<?php if ($product["enchantments"] != null && $product["enchantments"] != ""): ?>
										<div>
											<div class="form-label mb-0"><?php e__('Enchantments') ?>:</div>
											<div>
												<?php foreach ($product["enchantments"] as $enchantment): ?>
													<?php echo "* Lvl. ".$enchantment["lvl"]." - ".$enchantment["enchantment"]."<br>"; ?>
												<?php endforeach; ?>
											</div>
										</div>
									<?php endif; ?>
									<?php if ($product["lore"] != null && $product["lore"] != ""): ?>
										<div>
											<div class="form-label mb-0"><?php e__('Lore') ?>:</div>
											<div style="color: #fff; padding: 15px; background-color: #0F000F; border: 3px solid #535353;">
												<?php echo $product["coloredLore"]; ?>
											</div>
										</div>
									<?php endif; ?>
									<?php if ($product["description"] != ""): ?>
										<div>
											<div class="form-label mb-0"><?php e__('Description') ?>:</div>
											<div class="ck-content">
												<?php echo $product["description"]; ?>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('bazaar.products.buy', ['id' => $product['id']]) ?>" method="post">
							<?php _csrf(); ?>
							
							<div class="row">
								<div class="col align-items-center">
									<span class="form-label mb-0"><?php e__('Total') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-success fw-bold fs-3">
										<?php echo money()->credits($product["price"]); ?>
									</span>
								</div>
							</div>
							
							<div class="pt-4">
								<button type="submit" name="checkout" id="checkoutButton" class="btn btn-success w-100"><?php e__('Buy Now') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>