<?php $this->layout('layouts/main'); ?>

<section class="section store-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 mb-3">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('bazaar.index'),
						"text" => t__('Bazaar')
					],
					[
						"text" => $server["name"]
					]
				]]) ?>
			</div>
		</div>
		<div class="row">
			<div id="modalBox"></div>
			<div class="col-md-12">
				<h2 class="page-title mb-3"><?php e__('Products') ?></h2>
				<?php if (count($products) > 0): ?>
					<div class="row row-gap-3 store-cards">
						<?php foreach ($products as $product): ?>
							<div class="col-md-3 col-sm-6 mb-grid-gutter">
								<div class="card card-product card-hover">
									<img class="card-img-top lazyload" data-src="<?php echo $product["image"]; ?>" src="/assets/core/images/loaders/store.png">
									<div class="card-body">
										<h3 class="fs-lg fw-medium my-2">
											<?php echo $product["coloredName"]; ?>
										</h3>
										<span class="text-heading fw-semibold">
											<span class="price">
												<?php echo money()->credits($product["price"]); ?>
											</span>
										</span>
										
										<div class="mt-auto">
											<a href="<?php echo url('bazaar.products.show', ['id' => $product["id"]]) ?>" class="btn btn-primary w-100 stretched-link">
												<i class="ti ti-shopping-cart me-1"></i>
												<?php e__('Buy Now') ?>
											</a>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No product were found!')]); ?>
				<?php endif; ?>
				
				<?php if (count($products) > 0): ?>
					<div class="col-md-12 d-flex justify-content-center mt-4">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
