<?php $this->layout('layouts/main'); ?>

<section class="section news-section">
	<div class="container">
		<div class="row">
			<!-- Content-->
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Blog')
					]
				]]) ?>
			</div>
			
			<h2 class="page-title mt-3 mb-3"><?php e__('Blog') ?></h2>
			<div class="col-md-12">
				<?php if (count($posts) > 0): ?>
					<?php foreach ($posts as $post): ?>
						<div class="card card-hover mb-3">
							<div class="row g-0">
								<div class="col-md-5">
									<a class="d-flex h-100" href="<?php echo url('blog.posts.show', ["slug" => $post["slug"]]) ?>">
										<img class="lazyload card-img-right" data-src="<?php echo $post["image"]; ?>" src="/assets/core/images/loaders/news.png">
									</a>
								</div>
								<div class="col-md-7">
									<div class="card-body h-100 d-flex flex-column">
										<div>
											<a class="fs-sm mb-2" href="<?php echo url('blog.categories.show', ['slug' => $post["category"]["slug"]]); ?>">
												<?php echo $post["category"]["name"]; ?>
											</a>
											<span class="fs-sm mb-2">-</span>
											<span class="fs-sm mb-2">
												<?php echo carbon($post["creationDate"])->intlFormat(); ?>
											</span>
										</div>
										<h3 class="h3 mt-2 mb-2">
											<a href="<?php echo url('blog.posts.show', ['slug' => $post["slug"]]); ?>">
												<?php echo $post["title"]; ?>
											</a>
										</h3>
										<p class="mb-3"><?php echo limit_string($post["content"], 250); ?></p>
										<div class="d-flex justify-content-end mt-auto">
											<a href="<?php echo url('blog.posts.show', ['slug' => $post["slug"]]); ?>" class="btn btn-primary"><?php e__('Read More') ?></a>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
					
					<div class="d-md-flex justify-content-center align-items-center pt-5 pb-2">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php else : ?>
					<div class="col-md-12">
						<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No posts were found!')]); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>