<?php $this->layout('layouts/main'); ?>
<?php if (recaptcha()->isEnabled('reply_blog_post')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>
<?php $this->push('scripts'); ?>

<section class="section news-section">
	<div class="container">
		<div class="row justify-content-center">
			<!-- Content-->
			<div class="col-lg-10">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('blog.categories.show', ['slug' => $post["category"]["slug"]]),
						"text" => $post["category"]["name"]
					],
					[
						"text" => $post["title"]
					]
				]]) ?>
				
				<h1 class="page-title mt-3 mb-3">
					<?php echo $post["title"]; ?>
				</h1>
				<div class="card mb-5">
					<div class="card-body">
						<div class="row position-relative g-0 align-items-center">
							<div class="col-md-6 pb-4">
								<div class="d-flex align-items-center">
									<div class="d-flex align-items-center me-grid-gutter">
										<a class="d-block" href="<?php echo url('members.show', ['id' => $post["user"]["id"]]); ?>">
											<?php $this->insert('components/avatar', [
												'avatar' => $post["user"]["avatar"],
												'username' => $post["user"]["displayName"],
												'class' => 'avatar'
											]); ?>
										</a>
										<div class="ps-3">
											<h6 class="h4 mb-0">
												<a href="<?php echo url('members.show', ['id' => $post["user"]["id"]]); ?>">
													<?php echo $post["user"]["displayName"]; ?>
												</a>
											</h6>
											<div class="text-nowrap small">
												<div class="d-flex align-items-center gap-1">
													<i class="ti ti-calendar align-vertical icon-sm"></i> <?php echo carbon($post["creationDate"])->intlFormat(); ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-md-6 ps-md-3 py-3 d-none d-md-block">
								<div class="d-flex align-items-center justify-content-center justify-content-md-end">
									<span class="d-flex align-items-center gap-1 me-3">
										<i class="ti ti-eye"></i> <?php echo $post["views"]; ?>
									</span>
									<span class="d-flex align-items-center gap-1">
										<i class="ti ti-message"></i> <?php echo count($post["comments"]); ?>
									</span>
								</div>
							</div>
						</div>
						<!-- Post content-->
						<div class="article-content ck-content">
							<?php echo $post["content"]; ?>
						</div>
						<!-- Tags-->
						<div class="tags">
							<?php if (count($post["tags"]) > 0): ?>
								<?php e__('Tags') ?>:
								<?php foreach ($post["tags"] as $tag): ?>
								  <a class="btn btn-primary btn-sm me-1 my-2" href="<?php echo url('blog.tags.show', ["slug" => $tag["slug"]]) ?>">
										<?php echo $tag["name"]; ?>
								  </a>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php if ($post["commentsStatus"] == 1): ?>
					<?php if (auth()->check()): ?>
						<?php _message(); ?>
						<div class="mb-5">
							<h2 class="h3 mb-3"><?php e__('Leave a Reply') ?></h2>
							<div class="card">
								<div class="card-body">
									<form data-toggle="form-submit-with-loader" action="<?php echo url('blog.comments.store', ["postId" => $post["id"]]) ?>" method="post">
										<?php _csrf(); ?>
										<div class="row">
											<div class="col-auto">
												<?php $this->insert('components/avatar', [
													'avatar' => auth()->user()->avatar(),
													'username' => auth()->user()->displayName(),
													'class' => 'avatar float-left'
												]); ?>
											</div>
											<div class="col ps-0">
												<textarea name="message" class="form-control" rows="3" placeholder="<?php e__('Write a comment...') ?>"></textarea>
												<?php if (recaptcha()->isEnabled('reply_blog_post')) : ?>
													<div class="mt-3 d-flex justify-content-end">
														<?php echo recaptcha()->getHTML() ?>
													</div>
												<?php endif; ?>
												<div class="d-flex justify-content-end">
													<button name="insertNewsComments" type="submit" class="btn btn-primary mt-3"><?php e__('Send') ?></button>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					<?php else: ?>
						<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('You need to be signed in to comment.')]); ?>
					<?php endif; ?>
					<?php if (count($post["comments"]) > 0): ?>
						<div class="mb-5">
							<h2 class="h4 mb-3"><?php e__('Comments') ?></h2>
							<?php foreach ($post["comments"] as $comment): ?>
								<div class="card mb-2">
									<div class="card-body">
										<div class="row">
											<div class="col-auto">
												<a href="<?php echo url('members.show', ['id' => $comment["user"]["id"]]); ?>">
													<?php $this->insert('components/avatar', [
														'avatar' => $comment["user"]["avatar"],
														'username' => $comment["user"]["displayName"],
														'class' => 'avatar float-left'
													]); ?>
												</a>
											</div>
											<div class="col ps-2">
												<div class="row align-items-center">
													<div class="col">
														<a href="<?php echo url('members.show', ['id' => $comment["user"]["id"]]); ?>">
															<span class="h4">
																<?php echo $comment["user"]["displayName"]; ?>
															</span>
														</a>
													</div>
													<div class="col-auto">
														<span class="small">
															<?php echo carbon($comment["creationDate"])->intlFormat(); ?>
														</span>
													</div>
												</div>
												<div class="message-content">
													<?php echo $comment["message"]; ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					<?php else: ?>
						<?php if (auth()->check()): ?>
							<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('Hey, no comments yet! Would you like to comment first?')]); ?>
						<?php endif; ?>
					<?php endif; ?>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('Comments are closed!')]); ?>
				<?php endif; ?>
				
				<!-- Related posts -->
				<div class="mt-5 mb-5">
					<div class="row align-items-center pb-4">
						<div class="col">
							<h2 class="h3 mb-0"><?php e__('Related Posts') ?></h2>
						</div>
						<div class="col-auto">
							<a href="<?php echo url('blog.posts.index') ?>" class="btn btn-primary btn-sm"><?php e__('View All') ?></a>
						</div>
					</div>
					<div class="row">
						<?php if (count($post["relatedPosts"]) > 0): ?>
							<?php foreach ($post["relatedPosts"] as $relatedPost): ?>
								<div class="col-md-4">
									<article class="card card-hover">
										<a class="card-img-top" href="<?php echo url('blog.posts.show', ["slug" => $relatedPost["slug"]]) ?>">
											<img class="lazyload" data-src="<?php echo $relatedPost["image"]; ?>" src="/assets/core/images/loaders/news.png">
										</a>
										<div class="card-body">
											<div class="fs-sm mb-2">
												<a href="<?php echo url('blog.categories.show', ["slug" => $relatedPost["category"]["slug"]]) ?>">
													<?php echo $relatedPost["category"]["name"]; ?>
												</a>
												<span>-</span>
												<span>
													<?php echo carbon($relatedPost["creationDate"])->intlFormat(); ?>
												</span>
											</div>
											<h2 class="h3">
												<a href="<?php echo url('blog.posts.show', ["slug" => $relatedPost["slug"]]) ?>">
													<?php echo $relatedPost["title"]; ?>
												</a>
											</h2>
										</div>
									</article>
								</div>
							<?php endforeach; ?>
						<?php else: ?>
							<div class="col-12">
								<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No related posts!')]); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>