<?php $this->layout('layouts/main') ?>
<?php $this->insert('components/changelog-tags', ['tags' => $changelogTags]) ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('changelog.index'),
						"text" => t__('Changelog')
					],
					[
						'text' => $changelog["title"]
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<div class="card">
					<div class="card-header d-flex align-items-center justify-content-between">
						<h2 class="card-title"><?php echo $changelog["title"]; ?></h2>
						<span class="text-muted"><?php echo carbon($changelog["creationDate"])->intlFormat(); ?></span>
					</div>
					<div class="card-body">
						<?php foreach ($changelog["items"] as $item): ?>
							<div class="d-flex gap-2 mb-2">
								<span class="badge badge-secondary h-100 changelog-tag-<?php echo $item["tagID"]; ?>">
									<?php echo $item["tagName"]; ?>
								</span>
								<div class="ck-content">
									<?php echo $item["content"]; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>