<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('chest.index'),
						"text" => t__('Chest')
					],
					[
						"text" => t__('Send Gift')
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Send Gift') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('chest.gift.send', ["id" => $chest["id"]]) ?>" method="post">
							<?php _csrf(); ?>
							<div class="mb-3">
								<label for="inputProduct" class="form-label"><?php e__('Product') ?>:</label>
								<input type="text" id="inputProduct" class="form-control" value="<?php echo $chest["productName"]; ?>" readonly>
							</div>
							<?php if (count($chest["variables"]) > 0): ?>
								<?php foreach ($chest["variables"] as $variable): ?>
									<div class="mb-3">
										<label class="form-label"><?php echo $variable["name"] ?>:</label>
										<input type="text" class="form-control" value="<?php echo $variable["value"]; ?>" readonly>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>
							<div class="mb-3">
								<label for="inputUsername" class="form-label"><?php e__('Username') ?>:</label>
								<input type="text" id="inputUsername" class="form-control" name="username" placeholder="<?php e__('Enter the username') ?>" value="<?php _old('username') ?>">
							</div>
							<div class="mb-3">
								<label for="inputAmount" class="form-label"><?php e__('Quantity') ?>:</label>
								<input type="number" id="inputAmount" class="form-control" name="amount" placeholder="<?php e__('Enter the number of gifts to be sent.') ?>" value="<?php _old('amount', 1) ?>" min="1" max="<?php echo $chest["max"]; ?>">
								<small><?php e__('You can gift a maximum of %amount%', ['%amount%' => $chest["max"]]) ?></small>
							</div>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary" onclick="return confirm('<?php e__('Are you sure you want to send the gift to this player?') ?>')"><?php e__('Send') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			
			<div class="col-md-4">
				<div class="row">
					<div class="col-md-12">
							<div class="card">
								<div class="card-header justify-content-between">
									<h2 class="card-title fs-100"><?php e__('Chest History') ?></h2>
									<a href="<?php echo url('chest.logs') ?>" class="small"><?php e__('View All') ?></a>
								</div>
								<?php if (count($logs) > 0): ?>
									<div class="card-body p-0">
										<div class="table-responsive">
											<table class="table table-hover">
												<thead>
												<tr>
													<th><?php e__('Product') ?></th>
													<th class="text-center"><?php e__('Type') ?></th>
												</tr>
												</thead>
												<tbody>
												<?php foreach ($logs as $log): ?>
													<tr>
														<td><?php echo $log["productName"]; ?></td>
														<td class="text-center">
															<?php if ($log["type"] == 1): ?>
																<i class="fa fa-check text-success" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Delivery') ?>"></i>
															<?php elseif ($log["type"] == 2): ?>
																<i class="fa fa-gift text-primary" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift to %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
															<?php elseif ($log["type"] == 3): ?>
																<i class="fa fa-gift text-primary" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift from %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
															<?php else: ?>
																<i class="fa fa-check"></i>
															<?php endif; ?>
														</td>
													</tr>
												<?php endforeach; ?>
												</tbody>
											</table>
										</div>
									</div>
								<?php else: ?>
									<div class="card-body">
										<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
									</div>
								<?php endif; ?>
							</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
