<?php $this->layout('layouts/main'); ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/chest.js') ?>"></script>
<?php $this->end(); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Chest')
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<?php if (count($chests) > 0): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Chest') ?></h2>
						</div>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th><?php e__('Product') ?></th>
										<th><?php e__('Category') ?></th>
										<th><?php e__('Quantity') ?></th>
										<th><?php e__('Date') ?></th>
										<th class="text-end">&nbsp;</th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($chests as $chest): ?>
										<tr id="chest-<?php echo $chest["id"]; ?>">
											<td>
												<?php echo $chest["product"]["name"]; ?>
												<?php if (count($chest["product"]["variables"]) > 0): ?>
													<div class="mt-1">
														<?php foreach ($chest["product"]["variables"] as $variable): ?>
															<div class="small opacity-75">
																<?php echo $variable["name"] . ": " . $variable["value"]; ?>
															</div>
														<?php endforeach; ?>
													</div>
												<?php endif; ?>
											</td>
											<td>
												<span class="cursor-pointer" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo str_replace(["'", '"'], ["\'", '\"'], $chest['category']['list']); ?>">
													<?php  echo $chest["categoryName"]; ?>
												</span>
											</td>
											<td>
												<div class="input-group" style="width: 80px;">
													<button class="btn btn-sm btn-danger chestDecreaseButton" type="button" data-target="#amountChanger-<?php echo $chest["id"]; ?>">-</button>
													<input type="text" id="amountChanger-<?php echo $chest["id"]; ?>" class="form-control form-control-sm text-center px-0" value="<?php echo $chest["amount"]; ?>" min="1" max="<?php echo $chest["amount"]; ?>" autocomplete="off">
													<button class="btn btn-sm btn-success chestIncreaseButton" type="button" data-target="#amountChanger-<?php echo $chest["id"]; ?>">+</button>
												</div>
											</td>
											<td>
												<?php echo carbon($chest["creationDate"])->intlFormat(); ?>
											</td>
											<td class="text-end">
												<form data-toggle="form-submit-with-loader" action="<?php echo url('chest.deliver', ['id' => $chest["id"]]) ?>" method="post" class="d-inline-block">
													<?php _csrf(); ?>
													<input type="hidden" name="amount" value="<?php echo $chest["amount"]; ?>" id="amount-<?php echo $chest["id"]; ?>">
													<button type="submit" class="btn btn-success btn-icon btn-sm" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Take Delivery') ?>" onclick='return confirm("<?php e__('Please make sure you are on the server before confirming, otherwise the product may not reach you!'); ?>")'>
														<i class="ti ti-check"></i>
													</button>
												</form>
												<?php if (modules('chest')->settings('canSendGift') == 1 && $chest["canGift"] == 1): ?>
													<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('chest.gift.index', ["id" => $chest["id"]]); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Send as Gift') ?>">
														<i class="ti ti-gift"></i>
													</a>
												<?php endif; ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No items found in your chest!')]); ?>
				<?php endif; ?>
			</div>
			
			<div class="col-md-4">
				<div class="row">
					<div class="col-md-12">
						<div class="card">
							<div class="card-header justify-content-between">
								<h2 class="card-title fs-100"><?php e__('Chest History') ?></h2>
								<a href="<?php echo url('chest.logs') ?>" class="small"><?php e__('View All') ?></a>
							</div>
							<?php if (count($logs) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Product') ?></th>
												<th class="text-center"><?php e__('Type') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($logs as $log): ?>
												<tr>
													<td><?php echo $log["productName"]; ?></td>
													<td class="text-center">
														<?php if ($log["type"] == 1): ?>
															<i class="fa fa-check text-success" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Delivery') ?>"></i>
														<?php elseif ($log["type"] == 2): ?>
															<i class="fa fa-gift text-primary" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift to %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
														<?php elseif ($log["type"] == 3): ?>
															<i class="fa fa-gift text-primary" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift from %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
														<?php else: ?>
															<i class="fa fa-check"></i>
														<?php endif; ?>
													</td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else: ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
