<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("chest.index"),
						"text" => t__('Chest')
					],
					[
						"text" => t__('Chest History')
					]
				]]) ?>
			</div>
			
			<div class="col-md-12">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Chest History') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($logs) > 0): ?>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center">ID</th>
										<th><?php e__('Product') ?></th>
										<th><?php e__('Category') ?></th>
										<th class="text-center"><?php e__('Type') ?></th>
										<th><?php e__('Date') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($logs as $log): ?>
										<tr>
											<td class="text-center">
												#<?php echo $log["id"]; ?>
											</td>
											<td><?php echo $log["productName"]; ?></td>
											<td>
												<span class="cursor-pointer" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo str_replace(["'", '"'], ["\'", '\"'], $log['categoryList']); ?>">
													<?php echo $log["categoryName"]; ?>
												</span>
											</td>
											<td class="text-center">
												<?php if ($log["type"] == 1): ?>
													<i class="fa fa-check" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Delivery') ?>"></i>
												<?php elseif ($log["type"] == 2): ?>
													<i class="fa fa-gift" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift to %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
												<?php elseif ($log["type"] == 3): ?>
													<i class="fa fa-gift" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Gift from %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
												<?php else: ?>
													<i class="fa fa-check"></i>
												<?php endif; ?>
											</td>
											<td><?php echo carbon($log["creationDate"])->intlFormat(); ?></td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
