<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Buy Credits')
					]
				]]) ?>
			</div>
			
			<div class="col-md-8">
				<?php _message(); ?>
				<?php if ($emailStatus): ?>
					<?php if (modules('credit')->settings('multiplier') != 1): ?>
						<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('<strong>1 %currency% equals %multiplier% credits!</strong>', ['%currency%' => settings('currency'), '%multiplier%' => modules('credit')->settings('multiplier')])]); ?>
					<?php endif; ?>
					<?php if (modules('credit')->settings('bonusCredit') != 0 && (modules('credit')->settings('bonusCreditExpiryDate') == '1000-01-01 00:00:00' || modules('credit')->settings('bonusCreditExpiryDate') > datetime())): ?>
						<?php if (modules('credit')->settings('bonusCreditMinAmount') == 0): ?>
							<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('%credit%% bonus credits on purchases!', ['%credit%' => modules('credit')->settings('bonusCredit')])]); ?>
						<?php else: ?>
							<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('%bonus%% bonus on purchases over %credit% credits!', ['%credit%' => modules('credit')->settings('bonusCreditMinAmount'), '%bonus%' => modules('credit')->settings('bonusCredit')])]) ?>
						<?php endif; ?>
					<?php endif; ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Buy Credits') ?></h2>
						</div>
						<div class="card-body">
							<form data-toggle="form-submit-with-loader" id="buyCreditsForm" action="<?php echo url('credits.charge.action') ?>" method="post">
								<?php _csrf(); ?>
								
								<div class="mb-3">
									<label class="form-label" for="amount"><?php e__('Amount') ?>:</label>
									<input name="amount" id="amount" class="form-control" type="number" placeholder="<?php e__('Enter the amount.') ?>" required="" min="<?php echo modules('credit')->settings('minPay'); ?>" max="<?php echo modules('credit')->settings('maxPay'); ?>" value="<?php _old('amount') ?>">
								</div>
								
								<div class="mb-3">
									<label for="paymentGatewayID" class="form-label"><?php e__('Payment Method') ?>:</label>
									<select id="paymentGatewayID" class="form-control" name="paymentGatewayID" data-toggle="select2" required="required">
										<?php if (count($paymentGateways) > 0): ?>
											<?php foreach ($paymentGateways as $paymentGateway): ?>
												<option value="<?php echo $paymentGateway["slug"]; ?>">
													<?php echo $paymentGateway["title"]; ?>
												</option>
											<?php endforeach; ?>
										<?php else: ?>
											<option><?php e__('Payment method not found!') ?></option>
										<?php endif; ?>
									</select>
								</div>
								
								<?php if (modules('credit')->settings('showTermsCheckbox') == 1): ?>
									<div class="mb-3">
										<div class="form-check">
											<input name="terms" class="form-check-input" type="checkbox" id="terms" required>
											<label class="form-check-label" for="terms"><?php e__('I agree to the <a href="/terms" target="_blank">Terms & Conditions</a>') ?></label>
										</div>
									</div>
								<?php endif; ?>
								
								<div class="d-flex justify-content-end">
									<button type="submit" class="btn btn-primary"><?php e__('Buy Credits') ?></button>
								</div>
							</form>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('To buy credits, you need to update your email.')]); ?>
					<a href="<?php echo url('account.settings.security') ?>" class="btn btn-success w-100"><?php e__('Click to update your email.') ?></a>
				<?php endif; ?>
			</div>
			
			<div class="col-md-4">
				<div class="card">
					<div class="card-header justify-content-between">
						<h2 class="card-title fs-100"><?php e__('Credit History') ?></h2>
						<a href="<?php echo url('account.credit-history') ?>" class="small"><?php e__('View All') ?></a>
					</div>
					<?php if (count($logs) > 0): ?>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th><?php e__('Amount') ?></th>
										<th class="text-center"><?php e__('Type') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($logs as $log): ?>
										<tr>
											<td>
												<span class="text-success">+<?php echo money()->format($log["price"]); ?></span>
											</td>
											<td class="text-center">
												<span class="text-success">+<i class="fa fa-coins"></i></span>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					<?php else : ?>
						<div class="card-body">
							<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>