<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Buy Credits')
					]
				]]) ?>
			</div>
			
			<h2 class="page-title mt-3 mb-5"><?php e__('Credit Packages') ?></h2>
			
			<?php if (count($products) > 0): ?>
				<div class="row row-gap-3">
					<?php foreach ($products as $product): ?>
						<div class="col-md-3 col-sm-6">
							<div class="card card-product card-hover">
								<?php if ($product["bonus"] != 0): ?>
									<div class="stock have-stock bg-success">
										<?php e__('+%bonus% Bonus', ['%bonus%' => $product["bonus"]]) ?>
									</div>
								<?php else: ?>
									<?php if ($product["stock"] != -1): ?>
										<div class="stock <?php echo ($product["stock"] == 0) ? "stock-out" : "have-stock"; ?>">
											<?php if ($product["stock"] == 0): ?>
												<?php e__('Out of Stock!') ?>
											<?php else : ?>
												<?php e__('Limited Stock!') ?>
											<?php endif; ?>
										</div>
									<?php endif; ?>
								<?php endif; ?>
								<?php if ($product["discounted"]): ?>
									<div class="discount">
										<span>%<?php echo $product["discountPercent"]; ?></span>
									</div>
								<?php endif; ?>
								<img class="card-img-top lazyload" data-src="<?php echo $product["image"]; ?>" src="/assets/core/images/loaders/store.png">
								<div class="card-body">
									<h3 class="fs-lg fw-medium my-2">
										<?php echo $product["name"]; ?>
									</h3>
									<span class="text-heading fw-semibold">
										<?php if ($product["discounted"]): ?>
											<span class="old-price"><?php echo money()->real($product["price"]); ?></span>
											<small>/</small>
											<span class="price"><?php echo money()->real($product["discountedPrice"]); ?></span>
										<?php else: ?>
											<span class="price"><?php echo money()->real($product["price"]); ?></span>
										<?php endif; ?>
									</span>
									
									<div class="mt-auto">
										<?php if ($product["stock"] != -1): ?>
											<div class="mb-2">
												<?php if ($product["stock"] == 0): ?>
													<span class="text-danger small"><?php e__('Out of Stock!') ?></span>
												<?php else : ?>
													<span class="text-success small"><?php e__('%stock% in stock', ['%stock%' => $product["stock"]]) ?></span>
												<?php endif; ?>
											</div>
										<?php endif; ?>
										<?php if ($product["stock"] == 0): ?>
											<button class="btn btn-danger w-100 stretched-link disabled"><?php e__('Out of Stock!') ?></button>
										<?php else: ?>
											<a href="<?php echo url('credits.packages.show', ['id' => $product['id']]) ?>" class="btn btn-primary w-100 stretched-link">
												<i class="ti ti-shopping-cart me-1"></i>
												<?php e__('Buy Now') ?>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			<?php else: ?>
				<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No product were found!')]); ?>
			<?php endif; ?>
		</div>
	</div>
</section>
