<?php $this->layout('layouts/main') ?>
<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('credits.packages.index'),
						"text" => t__("Credit Packages")
					],
					[
						"text" => $product["name"]
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-body py-4">
						<div class="row">
							<div class="col-md-4">
								<img data-src="<?php echo $product["image"] ?>" alt="" class="lazyload w-100 mb-2" src="/assets/core/images/loaders/store.png">
							</div>
							<div class="col-md-8">
								<div>
									<h2 class="h2 mb-0"><?php echo $product["name"]; ?></h2>
									<p class="mb-3 opacity-75"><?php echo money()->credits($product["amount"]); ?></p>
									<div class="d-flex gap-2">
										<?php if ($product["discountPercent"] > 0): ?>
											<div class="px-2 py-1 rounded fw-semibold bg-info text-white"><?php e__('%discount%% OFF!', ['%discount%' => $product["discountPercent"]]) ?></div>
										<?php endif; ?>
										<?php if ($product["bonus"] > 0): ?>
											<div class="px-2 py-1 rounded fw-semibold bg-success text-white"><?php e__('+%bonus% Bonus', ['%bonus%' => $product["bonus"]]) ?></div>
										<?php endif; ?>
										<?php if ($product["stock"] != -1): ?>
											<div class="px-2 py-1 rounded fw-semibold text-white <?php echo ($product["stock"] == 0) ? "bg-danger" : "bg-warning"; ?>">
												<?php if ($product["stock"] == 0): ?>
													<?php e__('Out of Stock!') ?>
												<?php else : ?>
													<?php e__('Limited Stock!') ?>
												<?php endif; ?>
											</div>
										<?php endif; ?>
									</div>
								</div>
								<hr>
								<div class="ck-content mt-4">
									<?php echo $product["details"]; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('credits.packages.buy', ['id' => $product['id']]) ?>" method="post">
							<?php _csrf(); ?>
							
							<?php if ($product["discount"] > 0 || $product["tax"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Subtotal') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body">
											<?php echo money()->real($product["subtotal"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<?php if ($product["tax"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Tax') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger">
											<?php echo money()->real($product["tax"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<?php if ($product["discount"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Discount') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger">
											<?php echo money()->real($product["discount"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<div class="row">
								<div class="col align-items-center">
									<span class="form-label mb-0"><?php e__('Total') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-success fw-bold fs-3">
										<?php echo money()->real($product["total"]); ?>
									</span>
								</div>
							</div>
							
							<div class="row pt-4">
								<div class="col">
									<label for="selectPayment" class="form-label mb-1"><?php e__('Payment Method') ?>:</label>
									<select id="selectPayment" class="form-control" name="paymentGatewayID" required="required">
										<?php if (count($paymentGateways) > 0): ?>
											<?php foreach ($paymentGateways as $paymentGateway): ?>
												<option value="<?php echo $paymentGateway["slug"]; ?>">
													<?php echo $paymentGateway["title"]; ?>
												</option>
											<?php endforeach; ?>
										<?php else: ?>
											<option><?php e__('Payment method not found!') ?></option>
										<?php endif; ?>
									</select>
								</div>
							</div>
							
							<?php if (modules('store')->settings('showTermsCheckbox') == 1): ?>
								<div class="row pt-3">
									<div class="col">
										<div class="form-check">
											<input name="terms" class="form-check-input" type="checkbox" id="terms" required>
											<label class="form-check-label" for="terms"><?php e__('I agree to the <a href="/terms" target="_blank">Terms & Conditions</a>') ?></label>
										</div>
									</div>
								</div>
							<?php endif; ?>
							<div class="pt-2">
								<button type="submit" name="checkout" id="checkoutButton" class="btn btn-success w-100"><?php e__('Checkout') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>