<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Send Credits')
					]
				]]) ?>
			</div>
			
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Send Credits') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('credits.send.action') ?>" method="post">
							<?php _csrf(); ?>
							<label for="username" class="form-label"><?php e__('Username') ?>:</label>
							<div class="mb-3">
								<input type="text" id="username" class="form-control" name="username" placeholder="<?php e__('Enter the username.') ?>" value="<?php echo (isset($target)) ? $target["uniqueIdentifier"] : null; ?>">
							</div>
							
							<div class="mb-3">
								<label class="form-label" for="amount"><?php e__('Amount') ?>:</label>
								<input name="amount" id="amount" class="form-control" type="number" placeholder="<?php e__('Enter the amount.') ?>" required="" value="<?php _old('amount'); ?>">
							</div>
							
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary" onclick="return confirm('<?php e__('Are you sure you want to send the credit to this player?') ?>')"><?php e__('Send Credits') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			
			<div class="col-md-4">
				<div class="card">
					<div class="card-header justify-content-between">
						<h2 class="card-title fs-100"><?php e__('Credit Transfer History') ?></h2>
						<a href="<?php echo url('account.credit-history') ?>" class="small"><?php e__('View All') ?></a>
					</div>
					<?php if (count($logs) > 0): ?>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th><?php e__('Amount') ?></th>
										<th class="text-center"><?php e__('Type') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($logs as $log): ?>
										<tr>
											<td>
												<?php if ($log["type"] == 3): ?>
													<span class="text-danger">-<?php echo money()->format($log["price"]) ?></span>
												<?php else: ?>
													<span class="text-success">+<?php echo money()->format($log["price"]) ?></span>
												<?php endif; ?>
											<td class="text-center">
												<?php if ($log["type"] == 3): ?>
													<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer to %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?>"></i>
												<?php elseif ($log["type"] == 4): ?>
													<i class="fa fa-paper-plane" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Transfer from %username%', ['%username%' => $log["otherAccountDisplayName"]]) ?> "></i>
												<?php endif; ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					<?php else : ?>
						<div class="card-body">
							<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>