<?php $this->layout('layouts/main'); ?>

<section class="section store-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Wheel of Fortune')
					]
				]]) ?>
			</div>
		</div>
		
		<h2 class="page-title mt-3 mb-3"><?php e__('Wheel of Fortune') ?></h2>
		<?php if (count($lotteries)): ?>
			<div class="row">
				<?php foreach ($lotteries as $lottery): ?>
					<div class="col-md-3">
						<div class="card">
							<div class="card-body text-center">
								<img class="mb-3" src="<?php echo $this->asset('/img/fortune-wheel.png') ?>" alt="<?php echo $lottery["title"]; ?>" width="100px">
								<h5 class="card-title mb-2"><?php echo $lottery["title"]; ?></h5>
								<p class="card-text">
									<?php if ($lottery["price"] == 0): ?>
										<?php e__('Free') ?>
									<?php else: ?>
										<?php echo money()->credits($lottery["price"]); ?>
									<?php endif; ?>
								</p>
								<a href="<?php echo url('fortune-wheel.show', ["slug" => $lottery["slug"]]); ?>" class="btn btn-primary">
									<?php e__('Play') ?>
								</a>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data were found!')]); ?>
		<?php endif; ?>
	</div>
</section>