<?php $this->layout('layouts/main'); ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" type="text/css" href="<?php echo $this->asset('/css/plugins/superwheel/superwheel.min.css'); ?>">
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
<script src="<?php echo $this->asset('/js/plugins/superwheel/superwheel.min.js') ?>"></script>
<script src="<?php echo $this->asset('/js/lottery.js') ?>"></script>
<?php $this->end(); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('fortune-wheel.index'),
						"text" => t__('Wheel of Fortune')
					],
					[
						"text" => $lottery["title"]
					]
				]]) ?>
			</div>
			<?php if (count($lotteries) > 0): ?>
				<div class="col-md-8">
					<div class="card">
						<div class="card-body p-0">
							<script type="text/javascript">
								var lotteryID = <?php echo $lottery["id"]; ?>;
								var slices = <?php echo json_encode($lottery["slices"]); ?>;
							</script>
							<div class="tab-content px-4 pb-5">
								<div class="d-flex justify-content-center align-items-center">
									<div class="superwheel"></div>
								</div>
								<p class="text-center my-4">
									<?php if ($lottery["price"] == 0): ?>
										<?php e__('You can play this game for free every <strong>%duration% hour(s)</strong>.', ['%duration%' => $lottery["duration"]]) ?>
									<?php else: ?>
										<?php e__('You can play this game for <strong>%price% credit(s)</strong>.', ['%price%' => $lottery["price"]]) ?>
									<?php endif; ?>
								</p>
								<div class="d-flex justify-content-center">
									<button id="playGame" class="btn btn-primary"><?php e__('Play') ?></button>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-4">
					<div class="card">
						<div class="card-header justify-content-between">
							<h2 class="card-title fs-100"><?php e__('%title% History', ['%title%' => $lottery["title"]]) ?></h2>
							<a href="<?php echo url('fortune-wheel.logs') ?>" class="small"><?php e__('View All') ?></a>
						</div>
						<?php if (count($logs) > 0): ?>
							<div class="card-body p-0">
								<div class="table-responsive">
									<table class="table table-hover">
										<thead>
										<tr>
											<th><?php e__('Prize') ?></th>
											<th class="text-end"><?php e__('Date') ?></th>
										</tr>
										</thead>
										<tbody>
										<?php foreach ($logs as $log): ?>
											<tr>
												<td>
													<?php echo $log["title"]; ?>
												</td>
												<td class="text-end">
													<?php echo carbon($log["creationDate"])->intlFormat(); ?>
												</td>
											</tr>
										<?php endforeach; ?>
										</tbody>
									</table>
								</div>
							</div>
						<?php else: ?>
							<div class="card-body">
								<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php else: ?>
				<div class="col-md-12">
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('Wheel of Fortune not found!')]); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>
