<?php $this->layout('layouts/main'); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row mb-3">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('forum.index'),
						"text" => t__('Forum')
					],
					($category["parent"] ? [
							"url" => url('forum.categories.show', ['id' => $category["parent"]["id"], 'slug' => $category["parent"]["slug"]]),
							"text" => $category["parent"]["name"]
					] : null),
					[
						"text" => $category["name"]
					],
				]]) ?>
			</div>
		</div>
		
		<div class="row">
			<div class="col-md-12">
				<div class="d-flex align-items-center justify-content-between mb-3">
					<h2 class="page-title mb-0">
						<?php echo $category["name"]; ?>
					</h2>
					<?php if (forum()->user()->can($category["id"], "CREATE_TOPICS")): ?>
						<a href="<?php echo url('forum.threads.create', null, ['category' => $category["id"]]); ?>" class="btn btn-primary">
							<i class="ti ti-plus me-1"></i>
							<?php e__('Post Thread') ?>
						</a>
					<?php endif; ?>
			</div>
			
			<?php if (count($category["subcategories"]) > 0): ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Subcategories') ?></h2>
					</div>
					<div class="card-body py-0 border-bottom-separator">
						<?php foreach ($category["subcategories"] as $subcategory): ?>
							<div class="row align-items-center">
								<div class="col-auto pe-1">
									<img src="<?php echo $subcategory["image"]; ?>" alt="<?php echo $subcategory["name"]; ?>" width="32" height="32">
								</div>
								<div class="col">
									<a href="<?php echo url('forum.categories.show', ['id' => $subcategory["id"], 'slug' => $subcategory["slug"]]); ?>" class="fw-bold">
										<?php echo $subcategory["name"]; ?>
									</a>
									<div>
										<span style="font-size: 15px;">
											<?php echo $subcategory["description"]; ?>
										</span>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			<?php endif; ?>
			
			<?php if (count($pinnedThreads) > 0 || count($threads) > 0): ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Threads') ?></h2>
					</div>
					<div class="card-body py-0 border-bottom-separator">
						<?php foreach ($pinnedThreads as $thread): ?>
							<div class="row align-items-center">
								<div class="col-auto pe-1">
									<?php $this->insert("components/avatar", [
										'avatar' => $thread["user"]["avatar"],
										'username' => $thread["user"]["displayName"],
										'class' => 'avatar'
									]) ?>
								</div>
								<div class="col">
									<i class="fa fa-thumbtack text-danger me-1"></i>
									<a href="<?php echo url('forum.threads.show', ['id' => $thread["id"], 'slug' => $thread["slug"]]); ?>" class="fw-bold">
										<?php echo $thread["title"]; ?>
									</a>
									<div class="small">
										<a href="<?php echo url('members.show', ['id' => $thread["user"]["id"]]); ?>" class="text-body"><?php echo $thread["user"]["displayName"]; ?></a>
										<span>•</span>
										<span><?php echo carbon($thread["creationDate"])->intlFormat(); ?></span>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
						
						<?php foreach ($threads as $thread): ?>
							<div class="row align-items-center">
								<div class="col-auto pe-1">
									<?php $this->insert("components/avatar", [
										'avatar' => $thread["user"]["avatar"],
										'username' => $thread["user"]["displayName"],
										'class' => 'avatar'
									]) ?>
								</div>
								<div class="col">
									<a href="<?php echo url('forum.threads.show', ['id' => $thread["id"], 'slug' => $thread["slug"]]); ?>" class="fw-bold">
										<?php echo $thread["title"]; ?>
									</a>
									<div class="small">
										<a href="<?php echo url('members.show', ['id' => $thread["user"]["id"]]); ?>" class="text-body"><?php echo $thread["user"]["displayName"]; ?></a>
										<span>•</span>
										<span><?php echo carbon($thread["creationDate"])->intlFormat(); ?></span>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
				
				<div class="col-md-12 d-flex justify-content-center mt-5">
					<?php $this->insert('components/pagination', [
						'page' => $page,
						'pageCount' => $pageCount,
					]) ?>
				</div>
			<?php else: ?>
				<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No threads were found!')]); ?>
			<?php endif; ?>
			</div>
		</div>
	</div>
</section>
