<?php $this->layout('layouts/main'); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Forum')
					]
				]]) ?>
			</div>
		</div>
		
		<div class="row">
			<div class="col-md-8">
				<?php if (count($categories) > 0): ?>
					<?php foreach ($categories as $category): ?>
						<div class="card">
							<?php if (count($category["subcategories"]) > 0): ?>
								<div class="card-header">
									<a class="card-title h3" href="<?php echo url('forum.categories.show', ['id' => $category["id"], 'slug' => $category["slug"]]); ?>">
										<?php echo $category["name"]; ?>
									</a>
								</div>
								<div class="card-body py-0 border-bottom-separator">
									<?php foreach ($category["subcategories"] as $subcategory): ?>
										<div class="row align-items-center">
											<div class="col-auto pe-1">
												<img src="<?php echo $subcategory["image"]; ?>" alt="<?php echo $subcategory["name"]; ?>" width="32" height="32">
											</div>
											<div class="col">
												<a href="<?php echo url('forum.categories.show', ['id' => $subcategory["id"], 'slug' => $subcategory["slug"]]); ?>" class="fw-bold">
													<?php echo $subcategory["name"]; ?>
												</a>
												<?php if (count($subcategory["subcategories"]) > 0): ?>
													<div>
														<?php foreach ($subcategory["subcategories"] as $childCategory): ?>
															<a class="small me-2" href="<?php echo url('forum.categories.show', ['id' => $childCategory["id"], 'slug' => $childCategory["slug"]]); ?>">
																<i class="fa fa-link"></i>
																<?php echo $childCategory["name"]; ?>
															</a>
														<?php endforeach; ?>
													</div>
												<?php endif; ?>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							<?php else: ?>
								<div class="card-header border-0">
									<a class="card-title h3" href="<?php echo url('forum.categories.show', ['id' => $category["id"], 'slug' => $category["slug"]]); ?>">
										<?php echo $category["name"]; ?>
									</a>
								</div>
							<?php endif; ?>
						</div>
					<?php endforeach; ?>
				<?php else: ?>
					<div class="col-md-12">
						<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data were found!')]); ?>
					</div>
				<?php endif; ?>
			</div>
			
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Latest Threads') ?></h2>
					</div>
					<?php if (count($recentThreads) > 0): ?>
						<div class="card-body py-0 border-bottom-separator">
							<?php foreach ($recentThreads as $recentThread): ?>
								<div class="row align-items-center">
									<div class="col-auto pe-1">
										<?php $this->insert("components/avatar", [
											'avatar' => $recentThread["user"]["avatar"],
											'username' => $recentThread["user"]["displayName"],
											'class' => 'avatar avatar-sm'
										]) ?>
									</div>
									<div class="col">
										<a href="<?php echo url('forum.threads.show', ['id' => $recentThread["id"], 'slug' => $recentThread["slug"]]); ?>" class="fw-bold">
											<?php echo $recentThread["title"]; ?>
										</a>
										<div class="small">
											<a href="<?php echo url('members.show', ['id' => $recentThread["user"]["id"]]) ?>" class="text-body"><?php echo $recentThread["user"]["displayName"]; ?></a>
											<span>•</span>
											<span><?php echo carbon($recentThread["creationDate"])->diffForHumans(); ?></span>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					<?php else: ?>
						<div class="card-body">
							<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No threads were found!')]); ?>
						</div>
					<?php endif; ?>
				</div>
				
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Latest Replies') ?></h2>
					</div>
					<?php if (count($recentReplies) > 0): ?>
						<div class="card-body py-0 border-bottom-separator">
							<?php foreach ($recentReplies as $recentReply): ?>
								<div class="row align-items-center">
									<div class="col-auto pe-1">
										<?php $this->insert("components/avatar", [
											'avatar' => $recentReply["user"]["avatar"],
											'username' => $recentReply["user"]["displayName"],
											'class' => 'avatar avatar-sm'
										]) ?>
									</div>
									<div class="col">
										<a href="<?php echo url('forum.threads.show', ['id' => $recentReply["id"], 'slug' => $recentReply["slug"]]); ?>" class="fw-bold">
											<?php echo $recentReply["title"]; ?>
										</a>
										<div class="small">
											<a href="<?php echo url('members.show', ['id' => $recentReply["user"]["id"]]) ?>" class="text-body"><?php echo $recentReply["user"]["displayName"]; ?></a>
											<span>•</span>
											<span><?php echo carbon($recentReply["creationDate"])->diffForHumans(); ?></span>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					<?php else: ?>
						<div class="card-body">
							<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__("No data were found!")]); ?>
						</div>
					<?php endif; ?>
				</div>
				
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Members Online') ?></h2>
					</div>
					<div class="card-body">
						<?php if (count($onlineUsers) > 0): ?>
							<div class="forum-online-users">
								<?php foreach ($onlineUsers as $onlineUser): ?>
									<a class="username__<?php echo $onlineUser["role"] ?>" href="<?php echo url('members.show', ['id' => $onlineUser["id"]]) ?>">
										<?php echo $onlineUser["displayName"]; ?>
									</a>
								<?php endforeach; ?>
							</div>
						<?php else: ?>
							<span class="text-danger"><?php e__("Not Found!"); ?></span>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
