<?php $this->layout('layouts/main'); ?>

<?php if (recaptcha()->isEnabled('post_thread')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('forum.index'),
						"text" => t__('Forum')
					],
					[
						"url" => url('forum.categories.show', ['id' => $category["id"], 'slug' => $category["slug"]]),
						"text" => $category["name"]
					],
					[
						"text" => t__('Post Thread')
					]
				]]) ?>
			</div>
		</div>
		
		<?php _message(); ?>
		<div class="card mb-0">
			<div class="card-header"><?php e__('Post Thread') ?></div>
			<div class="card-body">
				<div class="forum-content">
					<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.store', null, ['category' => $category['id']]) ?>" method="post">
						<?php _csrf(); ?>
						<div class="mb-3">
							<label for="title" class="form-label"><?php e__('Title') ?></label>
							<input type="text" class="form-control" id="title" name="title" value="<?php _old('title'); ?>">
						</div>
						<div class="mb-3">
							<label for="ckeditor" class="form-label"><?php e__('Message') ?></label>
							<textarea
								id="ckeditor"
								name="message"
								placeholder=""
								class="form-control"
								style="min-height: 500px;"
								data-upload="<?php echo url('forum.upload') ?>"
								data-csrf="<?php echo csrf_token(); ?>"><?php _old('message'); ?></textarea>
						</div>
						<?php if (recaptcha()->isEnabled('post_thread')) : ?>
							<div class="mb-3 d-flex justify-content-end">
								<?php echo recaptcha()->getHTML() ?>
							</div>
						<?php endif; ?>
						<div class="text-end">
							<button type="submit" class="btn btn-primary">
								<?php e__('Post Thread') ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>
