<?php $this->layout('layouts/main'); ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('forum.index'),
						"text" => t__('Forum')
					],
					[
						"url" => url('forum.categories.show', ['id' => $thread["category"]["id"], 'slug' => $thread["category"]["slug"]]),
						"text" => $thread["category"]["name"]
					],
					[
						"text" => $thread["title"]
					]
				]]) ?>
			</div>
		</div>
		
		<?php _message(); ?>
		<div class="card mb-0">
			<div class="card-header"><?php e__('Edit the thread') ?></div>
			<div class="card-body">
				<div class="forum-content">
					<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.update', ['id' => $thread["id"]]) ?>" method="post">
						<?php _method('PATCH'); ?>
						<?php _csrf(); ?>
						<div class="mb-3">
							<label for="title" class="form-label"><?php e__('Title') ?></label>
							<input type="text" class="form-control" id="title" name="title" value="<?php _old('title', $thread["title"]); ?>">
						</div>
						<div class="mb-3">
							<label for="ckeditor" class="form-label"><?php e__('Message') ?></label>
							<textarea
								id="ckeditor"
								name="message"
								placeholder=""
								class="form-control"
								style="min-height: 500px;"
								data-upload="<?php echo url('forum.upload') ?>"
								data-csrf="<?php echo csrf_token(); ?>"><?php _old('message', $thread["content"]); ?></textarea>
						</div>
						<div class="text-end">
							<button type="submit" class="btn btn-primary">
								<?php e__('Save Changes') ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>
