<?php $this->layout('layouts/main'); ?>

<?php if (recaptcha()->isEnabled('reply_thread')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('forum.index'),
						"text" => t__('Forum')
					],
					[
						"url" => url('forum.categories.show', ['id' => $thread["category"]["id"], 'slug' => $thread["category"]["slug"]]),
						"text" => $thread["category"]["name"]
					],
					[
						"text" => $thread["title"]
					]
				]]) ?>
			</div>
		</div>
		
		<div class="mb-3 mt-2">
			<?php _message(); ?>
			<h1 class="h3 fw-bold"><?php echo $thread["title"]; ?></h1>
			<div class="d-flex" style="font-size: 14px;">
				<span class="me-3">
					<i class="fa fa-user"></i>
					<a class="username__<?php echo $thread["user"]["primaryRole"]["slug"]; ?>" href="<?php echo url('members.show', ['id' => $thread["user"]["id"]]); ?>">
						<?php echo $thread["user"]["displayName"]; ?>
					</a>
				</span>
				<span class="me-3">
					<i class="fa fa-clock"></i>
					<?php echo carbon($thread["creationDate"])->intlFormat(); ?>
				</span>
				<span class="me-3">
					<i class="fa fa-eye"></i>
					<?php echo $thread["views"]; ?>
				</span>
			</div>
		</div>
		<style>
			.forum-avatar img {
				border-radius: 0.25rem !important;
			}
		</style>
		<div class="mb-4">
			<div class="row">
				<div class="col-md-3">
					<div class="card mb-1">
						<div class="card-body text-center">
							<a href="<?php echo url('members.show', ['id' => $thread["user"]["id"]]); ?>" class="d-block mb-2">
								<div class="forum-avatar <?php echo "avatar-" . $thread["user"]["primaryRole"]["slug"] ?> mb-2">
									<?php $this->insert("components/avatar", [
										'avatar' => $thread["user"]["avatar"],
										'username' => $thread["user"]["displayName"],
										'class' => 'avatar'
									]) ?>
								</div>
								<span class="username__<?php echo $thread["user"]["primaryRole"]["slug"]; ?>">
									<?php echo $thread["user"]["displayName"]; ?>
								</span>
							</a>
							<?php foreach ($thread["user"]["roles"] as $role): ?>
								<span class="role__default role__<?php echo $role["slug"] ?>">
									<?php echo $role["name"]; ?>
								</span>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
				<div class="col-md-9 ps-lg-0">
					<div class="card mb-1 h-100">
						<div class="card-body" style="padding-bottom: 4rem;">
							<div class="forum-content h-100">
								<?php echo $thread["content"]; ?>
							</div>
							<div class="border-top small pt-lg-2">
								<div class="row">
									<div class="col">
										<?php echo carbon($thread["creationDate"])->intlFormat(); ?>
									</div>
									<div class="col-auto">
										<div class="d-flex">
											<?php if ($thread["permissions"]["EDIT_THREAD"]): ?>
												<a href="<?php echo url('forum.threads.edit', ['id' => $thread["id"]]); ?>" class="no-underline d-flex align-items-center gap-1">
													<i class="ti ti-edit icon-sm"></i> <?php e__('Edit') ?>
												</a>
											<?php endif; ?>
											<?php if ($thread["permissions"]["PIN_THREAD"]): ?>
												<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.pin', ['id' => $thread["id"]]); ?>" method="post" class="d-inline-block">
													<?php _csrf(); ?>
													<button type="submit" class="btn-link no-underline d-flex align-items-center gap-1">
														<i class="ti ti-pin icon-sm"></i> <?php echo ($thread["isPinned"]) ? t__('Unpin') : t__('Pin') ?>
													</button>
												</form>
											<?php endif; ?>
											<?php if ($thread["permissions"]["LOCK_THREAD"]): ?>
												<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.lock', ['id' => $thread["id"]]); ?>" method="post" class="d-inline-block">
													<?php _csrf(); ?>
													<button type="submit" class="btn-link no-underline d-flex align-items-center gap-1">
														<i class="ti ti-<?php echo ($thread["isLocked"]) ? "lock-open" : "lock" ?> icon-sm"></i> <?php echo ($thread["isLocked"]) ? t__('Unlock') : t__('Lock') ?>
													</button>
												</form>
											<?php endif; ?>
											<?php if ($thread["permissions"]["DELETE_THREAD"]): ?>
												<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.destroy', ['id' => $thread["id"]]); ?>" method="post" class="d-inline-block">
													<?php _method('DELETE'); ?>
													<?php _csrf(); ?>
													<button type="submit" class="btn-link no-underline text-danger d-flex align-items-center gap-1 clickdelete">
														<i class="ti ti-trash icon-sm"></i> <?php e__('Delete') ?>
													</button>
												</form>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php foreach ($replies as $reply): ?>
			<div class="mb-2">
				<div class="row">
					<div class="col-md-3">
						<div class="card mb-1">
							<div class="card-body text-center">
								<a href="<?php echo url('members.show', ['id' => $reply["user"]["id"]]); ?>" class="d-block mb-2">
									<div class="forum-avatar <?php echo "avatar-" . $reply["user"]["primaryRole"]["slug"] ?> mb-2">
										<?php $this->insert("components/avatar", [
											'avatar' => $reply["user"]["avatar"],
											'username' => $reply["user"]["displayName"],
											'class' => 'avatar'
										]) ?>
									</div>
									<span class="username__<?php echo $reply["user"]["primaryRole"]["slug"] ?>">
										<?php echo $reply["user"]["displayName"]; ?>
									</span>
								</a>
								<?php foreach ($reply["user"]["roles"] as $role): ?>
									<span class="role__default <?php echo "role__".$role["slug"] ?>">
										<?php echo $role["name"]; ?>
									</span>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
					<div class="col-md-9 ps-lg-0">
						<div class="card mb-1 h-100">
							<div class="card-body" style="padding-bottom: 4rem;">
								<div class="forum-content h-100">
									<?php echo $reply["message"]; ?>
								</div>
								<div class="border-top small pt-2">
									<div class="row">
										<div class="col">
											<?php echo carbon($reply["creationDate"])->intlFormat(); ?>
										</div>
										<div class="col-auto">
											<div class="d-flex">
												<?php if ($reply["permissions"]["MANAGE_REPLY"]): ?>
													<a href="<?php echo url('forum.replies.edit', ['id' => $reply["id"]]); ?>" class="no-underline d-flex align-items-center gap-1">
														<i class="ti ti-edit icon-sm"></i> <?php e__('Edit') ?>
													</a>
													<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.replies.destroy', ['id' => $reply["id"]]); ?>" method="post" class="d-inline-block">
														<?php _method('DELETE'); ?>
														<?php _csrf(); ?>
														<button type="submit" class="btn-link no-underline text-danger d-flex align-items-center gap-1 clickdelete">
															<i class="ti ti-trash icon-sm"></i> <?php e__('Delete') ?>
														</button>
													</form>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
		
		<div class="col-md-12 d-flex justify-content-end my-4">
			<?php $this->insert('components/pagination', [
				'page' => $page,
				'pageCount' => $pageCount,
			]) ?>
		</div>
		
		<?php if (auth()->check()): ?>
			<?php if ($thread["isLocked"] == 0 || $thread["permissions"]["MODERATE_FORUM"]): ?>
				<?php if ($thread["permissions"]["CREATE_REPLIES"]): ?>
					<div class="row">
						<div class="col-md-3">
							<div class="card mb-1">
								<div class="card-body text-center">
									<div class="flex">
										<a href="<?php echo url('account.profile.index'); ?>" class="d-block">
											<div class="forum-avatar <?php echo "avatar-" . auth()->user()->primaryRoleSlug() ?> mb-2">
												<?php $this->insert("components/avatar", [
													'avatar' => auth()->user()->avatar(),
													'username' => auth()->user()->displayName(),
													'class' => 'avatar'
												]) ?>
											</div>
											<span class="d-block mb-2 fw-bold username__<?php echo auth()->user()->primaryRoleSlug() ?>">
												<?php echo auth()->user()->displayName(); ?>
											</span>
										</a>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-9 ps-lg-0">
							<div class="card mb-1">
								<div class="card-body">
									<?php if ($thread["isLocked"] == 1): ?>
										<p class="small text-warning"><?php e__("This thread is locked but you can reply.") ?></p>
									<?php endif; ?>
									<div class="forum-content">
										<form data-toggle="form-submit-with-loader" action="<?php echo url('forum.threads.reply', ['id' => $thread['id']]) ?>" method="post">
											<?php _csrf(); ?>
											<textarea
												id="ckeditor"
												name="message"
												placeholder="<?php e__('Write your reply here...') ?>"
												class="form-control"
												data-upload="<?php echo url('forum.upload') ?>"
												data-csrf="<?php echo csrf_token(); ?>"></textarea>
											<?php if (recaptcha()->isEnabled('reply_thread')) : ?>
												<div class="mt-3 d-flex justify-content-end">
													<?php echo recaptcha()->getHTML() ?>
												</div>
											<?php endif; ?>
											<div class="text-end mt-3">
												<button type="submit" class="btn btn-primary">
													<?php e__('Send') ?>
												</button>
											</div>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>
			<?php else: ?>
				<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__("You can't reply to this thread because it's locked!")]); ?>
			<?php endif; ?>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('You need to be signed in to reply.')]); ?>
		<?php endif; ?>
	</div>
</section>
