<?php $this->layout('layouts/main'); ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 mb-3">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Games')
					]
				]]) ?>
			</div>
		</div>
		
		<h2 class="page-title mb-3">
			<?php e__('Games') ?>
		</h2>
		
		<div class="row">
			<?php if (count($games) > 0): ?>
				<?php foreach ($games as $game): ?>
					<div class="col-md-4">
						<a class="card" href="<?php echo url('games.show', ['slug' => $game["slug"]]) ?>">
							<img class="card-img-top lazyload" data-src="<?php echo $game["image"] ?>" src="/assets/core/images/loaders/server.png">
							<div class="card-body">
								<h3 class="card-title">
									<?php echo $game["title"]; ?>
								</h3>
							</div>
						</a>
					</div>
				<?php endforeach; ?>
			<?php else: ?>
				<div class="col-md-12">
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data has been added to the site yet.')]); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>
