<?php $this->layout('layouts/main'); ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('games.index'),
						"text" => t__('Games')
					],
					[
						"text" => $game["title"]
					]
				]]) ?>
			</div>
		</div>
		
		<div class="row">
			<div class="col-md-3">
				<?php if (count($games) > 0): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Games') ?></h2>
						</div>
						<div class="card-body p-0">
							<ul class="list-group list-group-flush linked-list">
								<?php foreach ($games as $gameItem): ?>
									<li class="list-group-item <?php _active($gameItem["slug"] == $game["slug"]); ?>">
										<a href="<?php echo url('games.show', ['slug' => $gameItem["slug"]]) ?>">
											<?php echo $gameItem["title"]; ?>
										</a>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('Game not found!')]); ?>
				<?php endif; ?>
			</div>
			<div class="col-md-9">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php echo $game["title"]; ?></h2>
					</div>
					<div class="card-body">
						<div class="ck-content">
							<?php echo $game["content"]; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
