<?php $this->layout('layouts/main'); ?>

<?php $this->push('styles') ?>
<link href="https://cdn.jsdelivr.net/npm/@pqina/flip@1.8.4/dist/flip.min.css" rel="stylesheet">
<?php $this->end(); ?>

<?php $this->push('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/@pqina/flip@1.8.4/dist/flip.min.js"></script>
<script>
	function handleTickInit(tick) {
		
		// uncomment to set labels to different language
		
		var locale = {
			YEAR_PLURAL: '<?php e__('Years') ?>',
			YEAR_SINGULAR: '<?php e__('Year') ?>',
			MONTH_PLURAL: '<?php e__('Months') ?>',
			MONTH_SINGULAR: '<?php e__('Month') ?>',
			WEEK_PLURAL: '<?php e__('Weeks') ?>',
			WEEK_SINGULAR: '<?php e__('Week') ?>',
			DAY_PLURAL: '<?php e__('Days') ?>',
			DAY_SINGULAR: '<?php e__('Day') ?>',
			HOUR_PLURAL: '<?php e__('Hours') ?>',
			HOUR_SINGULAR: '<?php e__('Hour') ?>',
			MINUTE_PLURAL: '<?php e__('Minutes') ?>',
			MINUTE_SINGULAR: '<?php e__('Minute') ?>',
			SECOND_PLURAL: '<?php e__('Seconds') ?>',
			SECOND_SINGULAR: '<?php e__('Second') ?>',
		};
		
		for (var key in locale) {
			if (!locale.hasOwnProperty(key)) { continue; }
			tick.setConstant(key, locale[key]);
		}
		
		// create the countdown counter
		var counter = Tick.count.down('<?php echo $tick; ?>');
		
		counter.onupdate = function(value) {
			tick.value = value;
		};
	}
</script>
<?php $this->end(); ?>

<style>
	.tick {
		font-size:1rem; white-space:nowrap; font-family:arial,sans-serif; max-width: 38rem; margin: auto;
	}
	.tick-flip,.tick-text-inline {
		font-size:2.5em;
	}
	.tick-label {
		margin-top:1em;font-size:0.825em;
		font-weight: 600;
	}
	.tick-char {
		width:1.5em;
	}
	.tick-text-inline {
		display:inline-block;text-align:center;min-width:1em;
	}
	.tick-text-inline+.tick-text-inline {
		margin-left:-.325em;
	}
	.tick-group {
		margin:0 .5em;text-align:center;
	}
	.tick-text-inline {
		color: rgb(90, 93, 99) !important;
	}
	.tick-label {
		color: #fff !important;
	}
	.tick-flip-panel {
		color: rgb(255, 255, 255) !important;
	}
	.tick-flip {
		font-family: !important;
	}
	.tick-flip-panel-text-wrapper {
		line-height: 1.45 !important;
	}
	.tick-flip-panel {
		background-color: rgb(59, 61, 59) !important;
	}
	.tick-flip {
		border-radius:0.12em !important;
	}
</style>

<section class="section store-section">
	<div class="container">
		<div class="text-center pt-5">
			<h1><?php e__('Gaming Night') ?></h1>
			<p class="mb-5">
				<?php e__('The Gaming Night is on every %day% between %start%-%end%!', [
					'%day%' => t__(modules('gaming_night')->settings('day')),
					'%start%' => $gamingNightStartFormatted,
					'%end%' => $gamingNightEndFormatted
				]) ?>
			</p>
			
			<div class="tick" data-did-init="handleTickInit" data-credits="false">
				<div data-repeat="true" data-layout="horizontal fit" data-transform="preset(d, h, m, s) -> delay">
					<div class="tick-group">
						<div data-key="value" data-repeat="true" data-transform="pad(00) -> split -> delay">
							<span data-view="flip"></span>
						</div>
						<span data-key="label" data-view="text" class="tick-label"></span>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>