<?php $this->layout('layouts/main'); ?>

<section class="section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 mb-3">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Gaming Night')
					]
				]]) ?>
			</div>
			<div id="modalBox"></div>
			<div class="col-md-12">
				<h2 class="page-title mb-3"><?php e__('Products') ?></h2>
				<?php if (count($products) > 0): ?>
					<div class="row row-gap-3">
						<?php foreach ($products as $product): ?>
							<div class="col-md-3 col-sm-6">
								<div class="card card-product">
									<?php if ($product["stock"] != -1): ?>
										<div class="stock <?php echo ($product["stock"] == 0) ? "stock-out" : "have-stock"; ?>">
											<?php if ($product["stock"] == 0): ?>
												<?php e__('Out of Stock!') ?>
											<?php else : ?>
												<?php e__('Limited Stock!') ?>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									
									<div class="discount discount-sm">
										<span><?php echo $product["discountPercent"]; ?>%</span>
									</div>
									<img class="card-img-top lazyload" data-src="<?php echo $product["image"]; ?>" src="/assets/core/images/loaders/store.png">
									<div class="card-body">
										<h3 class="fs-lg fw-medium my-2">
											<?php echo $product["name"]; ?>
										</h3>
										<span class="text-heading fw-semibold">
											<span class="old-price"><?php echo money()->format($product["price"]); ?></span>
											<small>/</small>
											<span class="price"><?php echo money()->format($product["discountedPrice"]); ?></span>
										</span>
										
										<div class="mt-auto">
											<?php if ($product["stock"] != -1): ?>
												<div class="mb-2">
													<?php if ($product["stock"] == 0): ?>
														<span class="text-danger small"><?php e__('Out of Stock!') ?></span>
													<?php else : ?>
														<span class="text-success small"><?php e__('%stock% in stock', ['%stock%' => $product["stock"]]) ?></span>
													<?php endif; ?>
												</div>
											<?php endif; ?>
											<?php if ($product["stock"] == 0): ?>
												<button class="btn btn-danger w-100 stretched-link disabled"><?php e__('Out of Stock!') ?></button>
											<?php else: ?>
												<?php if ($product["subs"] && $product["priority"] < $product["subs"]["priority"]): ?>
													<a class="btn btn-primary w-100 stretched-link" href="<?php echo url('gaming-night.products.show', ['id' => $product["id"]]) ?>">
														<?php e__('Upgrade') ?>
													</a>
												<?php elseif ($product["subs"] && $product["priority"] >= $product["subs"]["priority"]): ?>
													<button class="btn btn-success w-100 stretched-link disabled">
														<?php e__('Buy Now') ?>
													</button>
												<?php else: ?>
													<a class="btn btn-primary w-100 stretched-link" href="<?php echo url('gaming-night.products.show', ['id' => $product["id"]]) ?>">
														<i class="ti ti-shopping-cart me-1"></i>
														<?php e__('Buy Now') ?>
													</a>
												<?php endif; ?>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data were found!')]); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>