<?php $this->layout('layouts/main') ?>
<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('gaming-night.index'),
						"text" => t__("Gaming Night")
					],
					[
						"text" => $product["name"]
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-body py-4">
						<div class="row">
							<div class="col-md-4">
								<img data-src="<?php echo $product["image"] ?>" alt="" class="lazyload w-100 mb-2" src="/assets/core/images/loaders/store.png">
							</div>
							<div class="col-md-8">
								<div>
									<p class="mb-0 opacity-75 small text-uppercase fw-semibold"><?php echo $product["category"]["name"] ?></p>
									<h2 class="h2 mb-2"><?php echo $product["name"]; ?></h2>
									<div class="d-flex gap-2">
										<?php if ($product["discountPercent"] > 0): ?>
											<div class="px-2 py-1 rounded fw-semibold bg-success text-white"><?php e__('%discount%% OFF!', ['%discount%' => $product["discountPercent"]]) ?></div>
										<?php endif; ?>
										<?php if ($product["stock"] != -1): ?>
											<div class="px-2 py-1 rounded fw-semibold text-white <?php echo ($product["stock"] == 0) ? "bg-danger" : "bg-warning"; ?>">
												<?php if ($product["stock"] == 0): ?>
													<?php e__('Out of Stock!') ?>
												<?php else : ?>
													<?php e__('Limited Stock!') ?>
												<?php endif; ?>
											</div>
										<?php endif; ?>
									</div>
								</div>
								<hr>
								<div class="ck-content mt-4">
									<?php echo $product["details"]; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('gaming-night.products.buy', ['id' => $product['id']]) ?>" method="post">
							<?php _csrf(); ?>
							
							<?php if ($product["discount"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Discount') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger">
											<?php echo money()->format($product["discount"]); ?>
										</span>
									</div>
								</div>
								
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Subtotal') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body">
											<?php echo money()->format($product["subtotal"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<div class="row">
								<div class="col align-items-center">
									<span class="form-label mb-0"><?php e__('Total') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-success fw-bold fs-3">
										<?php echo money()->format($product["total"]); ?>
									</span>
								</div>
							</div>
							
							<?php if (count($product["variables"]) > 0): ?>
								<hr class="my-0 mt-3">
								<?php foreach ($product["variables"] as $variable): ?>
									<div class="pt-3">
										<label for="variable_<?php echo $variable["id"] ?>" class="form-label">
											<?php echo $variable["name"] ?>:
										</label>
										<?php if ($variable["type"] == "dropdown"): ?>
											<select name="variable_<?php echo $variable["id"] ?>" id="variable_<?php echo $variable["id"] ?>" class="form-control" required>
												<?php if ($variable["description"]): ?>
													<option value="">
														<?php echo $variable["description"]; ?>
													</option>
												<?php endif; ?>
												<?php foreach ($variable["options"] as $option): ?>
													<option value="<?php echo $option["value"] ?>">
														<?php echo $option["name"] ?>
														<?php if ($option["price"] != 0): ?>
															(+<?php echo money()->format($option["price"]) ?>)
														<?php endif; ?>
													</option>
												<?php endforeach; ?>
											</select>
										<?php else: ?>
											<input type="text" class="form-control" id="variable_<?php echo $variable["id"] ?>" name="variable_<?php echo $variable["id"] ?>" placeholder="<?php echo $variable["description"]; ?>" value="<?php echo old('variable_' . $variable["id"]) ?>" required>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>
							
							<div class="pt-4">
								<?php if ($product["stock"] == 0): ?>
									<a href="#" class="btn btn-danger w-100 disabled" disabled>
										<?php e__('Out of Stock!') ?>
									</a>
								<?php else: ?>
									<button type="submit" name="checkout" id="checkoutButton" class="btn btn-success w-100"><?php e__('Buy Now') ?></button>
								<?php endif; ?>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>