<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Gift')
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Get the Gift') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('gifts.check') ?>" method="post">
							<?php _csrf(); ?>
							<div class="mb-3">
								<label class="form-label" for="gift"><?php e__('Code') ?>:</label>
								<input name="gift" id="gift" class="form-control" type="text" placeholder="<?php e__('Enter the gift code.') ?>" value="<?php _old('gift'); ?>">
							</div>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary"><?php e__('Get the Gift') ?></button>
							</div>
						</form>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="row">
					<div class="col-md-12">
						<div class="card">
							<div class="card-header justify-content-between">
								<h2 class="card-title fs-100"><?php e__('Gift History') ?></h2>
								<a href="<?php echo url('gifts.logs') ?>" class="small"><?php e__('View All') ?></a>
							</div>
							<?php if ($logs): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Code') ?></th>
												<th class="text-end"><?php e__('Date') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($logs as $log): ?>
												<tr>
													<td><?php echo $log["giftName"]; ?></td>
													<td class="text-end">
														<?php echo carbon($log["creationDate"])->intlFormat(); ?>
													</td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else : ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>