<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("gifts.index"),
						"text" => t__('Gift')
					],
					[
						"text" => t__('Gift History')
					]
				]]) ?>
			</div>
			
			<div class="col-md-12">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title">
							<?php e__('Gift History') ?>
						</h2>
					</div>
					<div class="card-body p-0">
						<?php if (count($logs) > 0): ?>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center">ID</th>
										<th><?php e__('Code') ?></th>
										<th><?php e__('Gift') ?></th>
										<th><?php e__('Date') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($logs as $log): ?>
										<tr>
											<td class="text-center">#<?php echo $log["id"]; ?></td>
											<td>
												<?php echo $log["name"]; ?>
											</td>
											<td>
												<?php if ($log["giftType"] == 1): ?>
													<?php echo $log["gift"]; ?>
												<?php else: ?>
													<?php e__('%credit% credit(s)', ['%credit%' => $log["gift"]]) ?>
												<?php endif; ?>
											</td>
											<td><?php echo carbon($log["creationDate"])->intlFormat(); ?></td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						<?php else: ?>
							<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
