<?php $this->layout('layouts/main'); ?>

<section class="section credit-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url("gifts.index"),
						"text" => t__('Gift')
					],
					[
						"text" => $gift["name"]
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php if ($gift): ?>
					<form data-toggle="form-submit-with-loader" action="<?php echo url('gifts.use', ['id' => $gift["id"]]) ?>" method="post">
						<?php _csrf(); ?>
						<div class="card">
							<div class="card-header">
								<h2 class="card-title">
									<?php e__('Get the Gift') ?>
								</h2>
							</div>
							<div class="card-body">
								<div class="row">
									<?php if ($gift["giftType"] == 1): ?>
										<div class="col-md-12">
											<div class="title background mt-0"><span><?php e__('Product Details') ?></span></div>
										</div>
										<div class="col-6">
											<div class="store-card">
												<img class="store-card-img" src="/assets/core/images/store/products/<?php echo $gift["gift"]["imageID"].'.'.$gift["gift"]["imageType"]; ?>">
											</div>
										</div>
										<div class="col-6">
											<div class="row mb-1">
												<span class="col-sm-4 fw-bold"><?php e__('Name') ?>:</span>
												<span class="col-sm-8"><?php echo $gift["gift"]["name"]; ?></span>
											</div>
											<div class="row mb-1">
												<span class="col-sm-4 fw-bold"><?php e__('Category') ?>:</span>
												<span class="col-sm-8"><?php echo $gift["gift"]["categoryName"]; ?></span>
											</div>
											<div class="row mb-1">
												<span class="col-sm-4 fw-bold"><?php e__('Price') ?>:</span>
												<span class="col-sm-8 text-success">
													<?php e__('Free') ?>
												</span>
											</div>
											<div class="row mb-1">
												<span class="col-sm-4 fw-bold"><?php e__('Duration') ?>:</span>
												<span class="col-sm-8">
													<?php if ($gift["gift"]["duration"] == 0): ?>
														<?php e__('Unlimited') ?>
													<?php elseif ($gift["gift"]["duration"] == -1): ?>
														<?php e__('One-Time') ?>
													<?php else : ?>
														<?php e__('%day% day(s)', ['%day%' => $gift["gift"]["duration"]]) ?>
													<?php endif; ?>
												</span>
											</div>
											<div class="mt-4">
												<button type="submit" class="btn btn-primary w-100"><?php e__('Get the Gift') ?></button>
											</div>
										</div>
									<?php else: ?>
										<div class="col-md-12">
											<div class="form-group">
												<p><?php e__('When you click the "Get the Gift" button, <strong>%credit% credit(s)</strong> will be given to your account.', ['%credit%' => $gift["gift"]]) ?></p>
											</div>
											<div class="clearfix">
												<div class="float-end">
													<button type="submit" class="btn btn-success btn-rounded w-100" name="getGift"><?php e__('Get the Gift') ?></button>
												</div>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</form>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('Gift not found!')]); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>